/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.RandomizableIteratedSingleClassifierEnhancer;
import weka.classifiers.trees.J48;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Randomizable;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Normalize;
import weka.filters.unsupervised.attribute.PrincipalComponents;
import weka.filters.unsupervised.attribute.RemoveUseless;
import weka.filters.unsupervised.instance.RemovePercentage;

public class RotationForest
extends RandomizableIteratedSingleClassifierEnhancer
implements WeightedInstancesHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = -3255631880798499936L;
    protected int m_MinGroup = 3;
    protected int m_MaxGroup = 3;
    protected boolean m_NumberOfGroups = false;
    protected int m_RemovedPercentage = 50;
    protected int[][][] m_Groups = null;
    protected Filter m_ProjectionFilter = null;
    protected Filter[][] m_ProjectionFilters = null;
    protected Instances[] m_Headers = null;
    protected Instances[][] m_ReducedHeaders = null;
    protected RemoveUseless m_RemoveUseless = null;
    protected Normalize m_Normalize = null;

    public RotationForest() {
        this.m_Classifier = new J48();
        this.m_ProjectionFilter = this.defaultFilter();
    }

    protected Filter defaultFilter() {
        PrincipalComponents principalComponents = new PrincipalComponents();
        principalComponents.setNormalize(false);
        principalComponents.setVarianceCovered(1.0);
        return principalComponents;
    }

    public String globalInfo() {
        return "Class for construction a Rotation Forest. Can do classification and regression depending on the base learner. \n\nFor more information, see\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Juan J. Rodriguez and Ludmila I. Kuncheva and Carlos J. Alonso");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2006");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Rotation Forest: A new classifier ensemble method");
        technicalInformation.setValue(TechnicalInformation.Field.JOURNAL, "IEEE Transactions on Pattern Analysis and Machine Intelligence");
        technicalInformation.setValue(TechnicalInformation.Field.VOLUME, "28");
        technicalInformation.setValue(TechnicalInformation.Field.NUMBER, "10");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "1619-1630");
        technicalInformation.setValue(TechnicalInformation.Field.ISSN, "0162-8828");
        technicalInformation.setValue(TechnicalInformation.Field.URL, "http://doi.ieeecomputersociety.org/10.1109/TPAMI.2006.211");
        return technicalInformation;
    }

    protected String defaultClassifierString() {
        return "weka.classifiers.trees.J48";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(5);
        vector.addElement(new Option("\tWhether minGroup (-G) and maxGroup (-H) refer to\n\tthe number of groups or their size.\n\t(default: false)", "N", 0, "-N"));
        vector.addElement(new Option("\tMinimum size of a group of attributes:\n\t\tif numberOfGroups is true, the minimum number\n\t\tof groups.\n\t\t(default: 3)", "G", 1, "-G <num>"));
        vector.addElement(new Option("\tMaximum size of a group of attributes:\n\t\tif numberOfGroups is true, the maximum number\n\t\tof groups.\n\t\t(default: 3)", "H", 1, "-H <num>"));
        vector.addElement(new Option("\tPercentage of instances to be removed.\n\t\t(default: 50)", "P", 1, "-P <num>"));
        vector.addElement(new Option("\tFull class name of filter to use, followed\n\tby filter options.\n\teg: \"weka.filters.unsupervised.attribute.PrincipalComponents-R 1.0\"", "F", 1, "-F <filter specification>"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        Object object;
        String string = Utils.getOption('F', stringArray);
        if (string.length() > 0) {
            object = Utils.splitOptions(string);
            if (((String[])object).length == 0) {
                throw new IllegalArgumentException("Invalid filter specification string");
            }
            String string2 = object[0];
            object[0] = "";
            this.setProjectionFilter((Filter)Utils.forName(Filter.class, string2, (String[])object));
        } else {
            this.setProjectionFilter(this.defaultFilter());
        }
        object = Utils.getOption('G', stringArray);
        if (((String)object).length() != 0) {
            this.setMinGroup(Integer.parseInt((String)object));
        } else {
            this.setMinGroup(3);
        }
        object = Utils.getOption('H', stringArray);
        if (((String)object).length() != 0) {
            this.setMaxGroup(Integer.parseInt((String)object));
        } else {
            this.setMaxGroup(3);
        }
        object = Utils.getOption('P', stringArray);
        if (((String)object).length() != 0) {
            this.setRemovedPercentage(Integer.parseInt((String)object));
        } else {
            this.setRemovedPercentage(50);
        }
        this.setNumberOfGroups(Utils.getFlag('N', stringArray));
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = super.getOptions();
        String[] stringArray2 = new String[stringArray.length + 9];
        int n = 0;
        if (this.getNumberOfGroups()) {
            stringArray2[n++] = "-N";
        }
        stringArray2[n++] = "-G";
        stringArray2[n++] = "" + this.getMinGroup();
        stringArray2[n++] = "-H";
        stringArray2[n++] = "" + this.getMaxGroup();
        stringArray2[n++] = "-P";
        stringArray2[n++] = "" + this.getRemovedPercentage();
        stringArray2[n++] = "-F";
        stringArray2[n++] = this.getProjectionFilterSpec();
        System.arraycopy(stringArray, 0, stringArray2, n, stringArray.length);
        n += stringArray.length;
        while (n < stringArray2.length) {
            stringArray2[n++] = "";
        }
        return stringArray2;
    }

    public String numberOfGroupsTipText() {
        return "Whether minGroup and maxGroup refer to the number of groups or their size.";
    }

    public void setNumberOfGroups(boolean bl) {
        this.m_NumberOfGroups = bl;
    }

    public boolean getNumberOfGroups() {
        return this.m_NumberOfGroups;
    }

    public String minGroupTipText() {
        return "Minimum size of a group (if numberOfGrups is true, the minimum number of groups.";
    }

    public void setMinGroup(int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException("MinGroup has to be positive.");
        }
        this.m_MinGroup = n;
    }

    public int getMinGroup() {
        return this.m_MinGroup;
    }

    public String maxGroupTipText() {
        return "Maximum size of a group (if numberOfGrups is true, the maximum number of groups.";
    }

    public void setMaxGroup(int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException("MaxGroup has to be positive.");
        }
        this.m_MaxGroup = n;
    }

    public int getMaxGroup() {
        return this.m_MaxGroup;
    }

    public String removedPercentageTipText() {
        return "The percentage of instances to be removed.";
    }

    public void setRemovedPercentage(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("RemovedPercentage has to be >=0.");
        }
        if (n >= 100) {
            throw new IllegalArgumentException("RemovedPercentage has to be <100.");
        }
        this.m_RemovedPercentage = n;
    }

    public int getRemovedPercentage() {
        return this.m_RemovedPercentage;
    }

    public String projectionFilterTipText() {
        return "The filter used to project the data (e.g., PrincipalComponents).";
    }

    public void setProjectionFilter(Filter filter) {
        this.m_ProjectionFilter = filter;
    }

    public Filter getProjectionFilter() {
        return this.m_ProjectionFilter;
    }

    protected String getProjectionFilterSpec() {
        Filter filter = this.getProjectionFilter();
        if (filter instanceof OptionHandler) {
            return filter.getClass().getName() + " " + Utils.joinOptions(((OptionHandler)((Object)filter)).getOptions());
        }
        return filter.getClass().getName();
    }

    public String toString() {
        if (this.m_Classifiers == null) {
            return "RotationForest: No model built yet.";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("All the base classifiers: \n\n");
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            stringBuffer.append(this.m_Classifiers[i].toString() + "\n\n");
        }
        return stringBuffer.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 4626 $");
    }

    public void buildClassifier(Instances instances) throws Exception {
        Object object;
        int n;
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        super.buildClassifier(instances);
        this.checkMinMax(instances);
        Random random = instances.numInstances() > 0 ? instances.getRandomNumberGenerator(this.m_Seed) : new Random(this.m_Seed);
        this.m_RemoveUseless = new RemoveUseless();
        this.m_RemoveUseless.setInputFormat(instances);
        instances = Filter.useFilter(instances, this.m_RemoveUseless);
        this.m_Normalize = new Normalize();
        this.m_Normalize.setInputFormat(instances);
        instances = Filter.useFilter(instances, this.m_Normalize);
        if (this.m_NumberOfGroups) {
            this.generateGroupsFromNumbers(instances, random);
        } else {
            this.generateGroupsFromSizes(instances, random);
        }
        this.m_ProjectionFilters = new Filter[this.m_Groups.length][];
        for (n = 0; n < this.m_ProjectionFilters.length; ++n) {
            this.m_ProjectionFilters[n] = Filter.makeCopies(this.m_ProjectionFilter, this.m_Groups[n].length);
        }
        n = instances.numClasses();
        Instances[] instancesArray = new Instances[n + 1];
        if (instances.classAttribute().isNumeric()) {
            instancesArray = new Instances[n];
            instancesArray[0] = instances;
        } else {
            instancesArray = new Instances[n + 1];
            for (int i = 0; i < instancesArray.length; ++i) {
                instancesArray[i] = new Instances(instances, 0);
            }
            Enumeration enumeration = instances.enumerateInstances();
            while (enumeration.hasMoreElements()) {
                object = (Instances[])enumeration.nextElement();
                if (((Instance)object).classIsMissing()) {
                    instancesArray[n].add((Instance)object);
                    continue;
                }
                int n2 = (int)((Instance)object).classValue();
                instancesArray[n2].add((Instance)object);
            }
            if (instancesArray[n].numInstances() == 0) {
                object = instancesArray;
                instancesArray = new Instances[n];
                System.arraycopy(object, 0, instancesArray, 0, n);
            }
        }
        this.m_Headers = new Instances[this.m_Classifiers.length];
        this.m_ReducedHeaders = new Instances[this.m_Classifiers.length][];
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            Object object2;
            RevisionHandler revisionHandler;
            Object object3;
            this.m_ReducedHeaders[i] = new Instances[this.m_Groups[i].length];
            object = new FastVector(instances.numAttributes());
            for (int j = 0; j < this.m_Groups[i].length; ++j) {
                RevisionHandler revisionHandler2;
                Object object4;
                object3 = new FastVector(this.m_Groups[i][j].length + 1);
                for (int k = 0; k < this.m_Groups[i][j].length; ++k) {
                    ((FastVector)object3).addElement(instances.attribute(this.m_Groups[i][j][k]).copy());
                }
                ((FastVector)object3).addElement(instances.classAttribute().copy());
                revisionHandler = new Instances("rotated-" + i + "-" + j + "-", (FastVector)object3, 0);
                ((Instances)revisionHandler).setClassIndex(((Instances)revisionHandler).numAttributes() - 1);
                this.m_ReducedHeaders[i][j] = new Instances((Instances)revisionHandler, 0);
                object2 = this.selectClasses(instancesArray.length, random);
                for (int k = 0; k < ((Object)object2).length; ++k) {
                    if (object2[k] == false) continue;
                    object4 = instancesArray[k].enumerateInstances();
                    while (object4.hasMoreElements()) {
                        revisionHandler2 = (Instance)object4.nextElement();
                        Instance instance = new Instance(((Instances)revisionHandler).numAttributes());
                        instance.setDataset((Instances)revisionHandler);
                        for (int i2 = 0; i2 < this.m_Groups[i][j].length; ++i2) {
                            instance.setValue(i2, ((Instance)revisionHandler2).value(this.m_Groups[i][j][i2]));
                        }
                        instance.setClassValue(((Instance)revisionHandler2).classValue());
                        ((Instances)revisionHandler).add(instance);
                    }
                }
                ((Instances)revisionHandler).randomize(random);
                RevisionHandler revisionHandler3 = revisionHandler;
                ((Instances)revisionHandler).randomize(random);
                object4 = new RemovePercentage();
                ((RemovePercentage)object4).setPercentage(this.m_RemovedPercentage);
                ((RemovePercentage)object4).setInputFormat((Instances)revisionHandler);
                revisionHandler = Filter.useFilter((Instances)revisionHandler, (Filter)object4);
                if (((Instances)revisionHandler).numInstances() < 2) {
                    revisionHandler = revisionHandler3;
                }
                this.m_ProjectionFilters[i][j].setInputFormat((Instances)revisionHandler);
                revisionHandler2 = null;
                do {
                    try {
                        revisionHandler2 = Filter.useFilter((Instances)revisionHandler, this.m_ProjectionFilters[i][j]);
                    }
                    catch (Exception exception) {
                        this.addRandomInstances((Instances)revisionHandler, 10, random);
                    }
                } while (revisionHandler2 == null);
                for (int k = 0; k < ((Instances)revisionHandler2).numAttributes() - 1; ++k) {
                    ((FastVector)object).addElement(((Instances)revisionHandler2).attribute(k).copy());
                }
            }
            ((FastVector)object).addElement(instances.classAttribute().copy());
            Instances instances2 = new Instances("rotated-" + i + "-", (FastVector)object, 0);
            instances2.setClassIndex(instances2.numAttributes() - 1);
            this.m_Headers[i] = new Instances(instances2, 0);
            object3 = instances.enumerateInstances();
            while (object3.hasMoreElements()) {
                revisionHandler = (Instance)object3.nextElement();
                object2 = this.convertInstance((Instance)revisionHandler, i);
                instances2.add((Instance)object2);
            }
            if (this.m_Classifier instanceof Randomizable) {
                ((Randomizable)((Object)this.m_Classifiers[i])).setSeed(random.nextInt());
            }
            this.m_Classifiers[i].buildClassifier(instances2);
        }
        if (this.m_Debug) {
            this.printGroups();
        }
    }

    protected void addRandomInstances(Instances instances, int n, Random random) {
        int n2 = instances.numAttributes();
        double[] dArray = new double[n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                Attribute attribute = instances.attribute(j);
                if (attribute.isNumeric()) {
                    dArray[j] = random.nextDouble();
                    continue;
                }
                if (!attribute.isNominal()) continue;
                dArray[j] = random.nextInt(attribute.numValues());
            }
            instances.add(new Instance(1.0, dArray));
        }
    }

    protected void checkMinMax(Instances instances) {
        int n;
        if (this.m_MinGroup > this.m_MaxGroup) {
            n = this.m_MaxGroup;
            this.m_MaxGroup = this.m_MinGroup;
            this.m_MinGroup = n;
        }
        if (this.m_MaxGroup >= (n = instances.numAttributes())) {
            this.m_MaxGroup = n - 1;
        }
        if (this.m_MinGroup >= n) {
            this.m_MinGroup = n - 1;
        }
    }

    protected boolean[] selectClasses(int n, Random random) {
        int n2 = 0;
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < blArray.length; ++i) {
            if (!random.nextBoolean()) continue;
            blArray[i] = true;
            ++n2;
        }
        if (n2 == 0) {
            blArray[random.nextInt((int)blArray.length)] = true;
        }
        return blArray;
    }

    protected void generateGroupsFromSizes(Instances instances, Random random) {
        this.m_Groups = new int[this.m_Classifiers.length][][];
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            int n;
            int[] nArray = this.attributesPermutation(instances.numAttributes(), instances.classIndex(), random);
            int[] nArray2 = new int[this.m_MaxGroup - this.m_MinGroup + 1];
            int n2 = 0;
            int n3 = 0;
            while (n2 < nArray.length) {
                int n4 = n = random.nextInt(nArray2.length);
                nArray2[n4] = nArray2[n4] + 1;
                n2 += this.m_MinGroup + n;
                ++n3;
            }
            this.m_Groups[i] = new int[n3][];
            n = 0;
            int n5 = 0;
            for (int j = 0; j < n3; ++j) {
                while (nArray2[n5] == 0) {
                    ++n5;
                }
                int n6 = n5;
                nArray2[n6] = nArray2[n6] - 1;
                int n7 = this.m_MinGroup + n5;
                this.m_Groups[i][j] = new int[n7];
                for (int k = 0; k < n7; ++k) {
                    this.m_Groups[i][j][k] = n < nArray.length ? nArray[n] : nArray[random.nextInt(nArray.length)];
                    ++n;
                }
            }
        }
    }

    protected void generateGroupsFromNumbers(Instances instances, Random random) {
        this.m_Groups = new int[this.m_Classifiers.length][][];
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            int[] nArray = this.attributesPermutation(instances.numAttributes(), instances.classIndex(), random);
            int n = this.m_MinGroup + random.nextInt(this.m_MaxGroup - this.m_MinGroup + 1);
            this.m_Groups[i] = new int[n][];
            int n2 = nArray.length / n;
            int n3 = nArray.length % n;
            int n4 = 0;
            for (int j = 0; j < n; ++j) {
                this.m_Groups[i][j] = j < n3 ? new int[n2 + 1] : new int[n2];
                for (int k = 0; k < this.m_Groups[i][j].length; ++k) {
                    this.m_Groups[i][j][k] = nArray[n4++];
                }
            }
        }
    }

    protected int[] attributesPermutation(int n, int n2, Random random) {
        int n3;
        int[] nArray = new int[n - 1];
        for (n3 = 0; n3 < n2; ++n3) {
            nArray[n3] = n3;
        }
        while (n3 < nArray.length) {
            nArray[n3] = n3 + 1;
            ++n3;
        }
        this.permute(nArray, random);
        return nArray;
    }

    protected void permute(int[] nArray, Random random) {
        for (int i = nArray.length - 1; i > 0; --i) {
            int n = random.nextInt(i + 1);
            if (i == n) continue;
            int n2 = nArray[i];
            nArray[i] = nArray[n];
            nArray[n] = n2;
        }
    }

    protected void printGroups() {
        for (int i = 0; i < this.m_Groups.length; ++i) {
            for (int j = 0; j < this.m_Groups[i].length; ++j) {
                System.err.print("( ");
                for (int k = 0; k < this.m_Groups[i][j].length; ++k) {
                    System.err.print(this.m_Groups[i][j][k]);
                    System.err.print(" ");
                }
                System.err.print(") ");
            }
            System.err.println();
        }
    }

    protected Instance convertInstance(Instance instance, int n) throws Exception {
        Instance instance2 = new Instance(this.m_Headers[n].numAttributes());
        instance2.setDataset(this.m_Headers[n]);
        int n2 = 0;
        for (int i = 0; i < this.m_Groups[n].length; ++i) {
            int n3;
            Instance instance3 = new Instance(this.m_Groups[n][i].length + 1);
            for (n3 = 0; n3 < this.m_Groups[n][i].length; ++n3) {
                instance3.setValue(n3, instance.value(this.m_Groups[n][i][n3]));
            }
            instance3.setValue(n3, instance.classValue());
            instance3.setDataset(this.m_ReducedHeaders[n][i]);
            this.m_ProjectionFilters[n][i].input(instance3);
            instance3 = this.m_ProjectionFilters[n][i].output();
            this.m_ProjectionFilters[n][i].batchFinished();
            for (int j = 0; j < instance3.numAttributes() - 1; ++j) {
                instance2.setValue(n2++, instance3.value(j));
            }
        }
        instance2.setClassValue(instance.classValue());
        return instance2;
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        this.m_RemoveUseless.input(instance);
        instance = this.m_RemoveUseless.output();
        this.m_RemoveUseless.batchFinished();
        this.m_Normalize.input(instance);
        instance = this.m_Normalize.output();
        this.m_Normalize.batchFinished();
        double[] dArray = new double[instance.numClasses()];
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            Instance instance2 = this.convertInstance(instance, i);
            if (instance.classAttribute().isNumeric()) {
                dArray[0] = dArray[0] + this.m_Classifiers[i].classifyInstance(instance2);
                continue;
            }
            double[] dArray2 = this.m_Classifiers[i].distributionForInstance(instance2);
            for (int j = 0; j < dArray2.length; ++j) {
                int n = j;
                dArray[n] = dArray[n] + dArray2[j];
            }
        }
        if (instance.classAttribute().isNumeric()) {
            dArray[0] = dArray[0] / (double)this.m_NumIterations;
            return dArray;
        }
        if (Utils.eq(Utils.sum(dArray), 0.0)) {
            return dArray;
        }
        Utils.normalize(dArray);
        return dArray;
    }

    public static void main(String[] stringArray) {
        RotationForest.runClassifier(new RotationForest(), stringArray);
    }
}

