/*
 * Decompiled with CFR 0.152.
 */
package weka.core.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Properties;
import weka.core.RevisionHandler;
import weka.core.Utils;
import weka.core.logging.ConsoleLogger;
import weka.gui.LogPanel;

public abstract class Logger
implements RevisionHandler {
    public static final String PROPERTIES_FILE = "weka/core/logging/Logging.props";
    protected Level m_MinLevel;
    protected static Logger m_Singleton;
    protected static Properties m_Properties;
    protected static SimpleDateFormat m_DateFormat;

    public Logger() {
        this.initialize();
    }

    protected void initialize() {
        this.m_MinLevel = Level.valueOf(m_Properties.getProperty("MinLevel", "INFO"));
    }

    public Level getMinLevel() {
        return this.m_MinLevel;
    }

    protected static String[] getLocation() {
        String[] stringArray = new String[3];
        Throwable throwable = new Throwable();
        throwable.fillInStackTrace();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            if (stackTraceElementArray[i].getClassName().equals(Logger.class.getName()) || stackTraceElementArray[i].getClassName().equals(LogPanel.class.getName())) continue;
            stringArray[0] = stackTraceElementArray[i].getClassName();
            stringArray[1] = stackTraceElementArray[i].getMethodName();
            stringArray[2] = "" + stackTraceElementArray[i].getLineNumber();
            break;
        }
        return stringArray;
    }

    protected abstract void doLog(Level var1, String var2, String var3, String var4, int var5);

    public static Logger getSingleton() {
        if (m_Singleton == null) {
            String string = m_Properties.getProperty("Logger", ConsoleLogger.class.getName());
            try {
                m_Singleton = (Logger)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            m_DateFormat = new SimpleDateFormat(m_Properties.getProperty("DateFormat", "yyyy-MM-dd HH:mm:ss"));
        }
        return m_Singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(Level level, String string) {
        Logger logger = Logger.getSingleton();
        if (logger == null) {
            return;
        }
        Logger logger2 = logger;
        synchronized (logger2) {
            boolean bl = false;
            if (logger.getMinLevel() == Level.ALL) {
                bl = true;
            } else if (level.getOrder() >= logger.getMinLevel().getOrder()) {
                bl = true;
            }
            if (!bl) {
                return;
            }
            String[] stringArray = Logger.getLocation();
            logger.doLog(level, string, stringArray[0], stringArray[1], Integer.parseInt(stringArray[2]));
        }
    }

    public static void log(Level level, Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.close();
        Logger.log(level, stringWriter.toString());
    }

    static {
        try {
            m_Properties = Utils.readProperties(PROPERTIES_FILE);
        }
        catch (Exception exception) {
            System.err.println("Error reading the logging properties 'weka/core/logging/Logging.props': " + exception);
            m_Properties = new Properties();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        ALL(0),
        FINEST(1),
        FINER(2),
        FINE(3),
        INFO(4),
        WARNING(5),
        SEVERE(6),
        OFF(10);

        private int m_Order;

        private Level(int n2) {
            this.m_Order = n2;
        }

        public int getOrder() {
            return this.m_Order;
        }
    }
}

