/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta.generators;

import weka.classifiers.meta.generators.InstanceHandler;
import weka.classifiers.meta.generators.NumericAttributeGenerator;
import weka.classifiers.meta.generators.RandomizableGenerator;
import weka.clusterers.EM;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instances;

public class EMGenerator
extends RandomizableGenerator
implements InstanceHandler,
NumericAttributeGenerator {
    private static final long serialVersionUID = 2769416817955024550L;
    protected EM m_EMModel;

    public String globalInfo() {
        return "A generator that uses EM as an underlying model.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities(this);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    public void buildGenerator(Instances someinstances) throws Exception {
        this.getCapabilities().testWithFail(someinstances);
        someinstances = new Instances(someinstances);
        someinstances.deleteWithMissing(0);
        this.m_EMModel = new EM();
        this.m_EMModel.setMaxIterations(10);
        this.m_EMModel.buildClusterer(someinstances);
    }

    public double generate() {
        double[] clusterProbabilities = this.m_EMModel.getClusterPriors();
        double clusterPicked = this.m_Random.nextDouble();
        double sum = 0.0;
        int clusterID = 0;
        int i = 0;
        while (i < clusterProbabilities.length) {
            if (clusterPicked > sum && clusterPicked <= sum + clusterProbabilities[i]) {
                clusterID = i;
                break;
            }
            sum += clusterProbabilities[i];
            clusterID = i++;
        }
        double[][][] normalDists = this.m_EMModel.getClusterModelsNumericAtts();
        double mean = normalDists[clusterID][0][0];
        double sd = normalDists[clusterID][0][1];
        double gaussian = this.m_Random.nextGaussian();
        double value = mean + gaussian * sd;
        return value;
    }

    public double getProbabilityOf(double valuex) {
        DenseInstance inst = new DenseInstance(1);
        inst.setValue(0, valuex);
        try {
            return Math.exp(this.m_EMModel.logDensityForInstance(inst));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
            return 0.0;
        }
    }

    public double getLogProbabilityOf(double valuex) {
        return Math.log(this.getProbabilityOf(valuex));
    }
}

