/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta.generators;

import weka.classifiers.meta.generators.NumericAttributeGenerator;
import weka.classifiers.meta.generators.RandomizableRangedGenerator;

public class UniformDataGenerator
extends RandomizableRangedGenerator
implements NumericAttributeGenerator {
    private static final long serialVersionUID = -6390354660638644832L;

    public String globalInfo() {
        return "A uniform artificial data generator.\n\nThis generator uses a uniform data model - all values have the same probability, and generated values must fall within the range given to the generator.";
    }

    public double generate() {
        double range = this.m_UpperRange - this.m_LowerRange;
        return this.m_Random.nextDouble() * range + this.m_LowerRange;
    }

    public double getProbabilityOf(double somedata) {
        double range = this.m_UpperRange - this.m_LowerRange;
        if (range <= 0.0 || somedata > this.m_UpperRange || somedata < this.m_LowerRange) {
            return Double.MIN_VALUE;
        }
        return 1.0 / range;
    }

    public double getLogProbabilityOf(double somedata) {
        double range = this.m_UpperRange - this.m_LowerRange;
        if (range <= 0.0 || somedata < this.m_LowerRange || somedata > this.m_UpperRange) {
            return Math.log(Double.MIN_VALUE);
        }
        return -Math.log(range);
    }
}

