/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.text.SimpleDateFormat;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SimpleDateFormatEditor
implements PropertyEditor {
    public static final String DEFAULT_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private SimpleDateFormat m_Format;
    private PropertyChangeSupport m_propSupport = new PropertyChangeSupport(this);
    private CustomEditor m_customEditor = new CustomEditor();

    public void setValue(Object value) {
        this.m_Format = (SimpleDateFormat)value;
        this.m_customEditor.formatChanged();
    }

    public Object getValue() {
        return this.m_Format;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        gfx.drawString(this.m_Format.toPattern(), box.x, box.y + box.height);
    }

    public String getJavaInitializationString() {
        return "new SimpleDateFormat(" + this.m_Format.toPattern() + ")";
    }

    public String getAsText() {
        return this.m_Format.toPattern();
    }

    public void setAsText(String text) {
        this.m_Format = new SimpleDateFormat(text);
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        return this.m_customEditor;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_propSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_propSupport.removePropertyChangeListener(listener);
    }

    private class CustomEditor
    extends JPanel
    implements ActionListener,
    DocumentListener {
        private static final long serialVersionUID = -4018834274636309987L;
        private JTextField m_FormatText = new JTextField(20);
        private JButton m_DefaultButton = new JButton("Default");
        private JButton m_ApplyButton = new JButton("Apply");

        public CustomEditor() {
            this.m_DefaultButton.setMnemonic('D');
            this.m_ApplyButton.setMnemonic('A');
            this.m_FormatText.getDocument().addDocumentListener(this);
            this.m_DefaultButton.addActionListener(this);
            this.m_ApplyButton.addActionListener(this);
            this.setLayout(new FlowLayout());
            this.add(new JLabel("ISO 8601 Date format"));
            this.add(this.m_FormatText);
            this.add(this.m_DefaultButton);
            this.add(this.m_ApplyButton);
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.m_DefaultButton) {
                this.defaultFormat();
            } else if (e.getSource() == this.m_ApplyButton) {
                this.applyFormat();
            }
        }

        public void defaultFormat() {
            this.m_FormatText.setText(SimpleDateFormatEditor.DEFAULT_FORMAT);
            this.formatChanged();
        }

        protected boolean isValidFormat() {
            boolean result = false;
            try {
                new SimpleDateFormat(this.m_FormatText.getText());
                result = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return result;
        }

        public void applyFormat() {
            if (!this.isValidFormat()) {
                throw new IllegalArgumentException("Date format '" + this.m_FormatText.getText() + "' is invalid! Cannot execute applyFormat!");
            }
            SimpleDateFormatEditor.this.m_Format = new SimpleDateFormat(this.m_FormatText.getText());
            SimpleDateFormatEditor.this.m_propSupport.firePropertyChange(null, null, null);
        }

        public void formatChanged() {
            this.m_FormatText.setText(SimpleDateFormatEditor.this.m_Format.toPattern());
            SimpleDateFormatEditor.this.m_propSupport.firePropertyChange(null, null, null);
        }

        public void changedUpdate(DocumentEvent e) {
            this.m_ApplyButton.setEnabled(this.isValidFormat());
        }

        public void insertUpdate(DocumentEvent e) {
            this.m_ApplyButton.setEnabled(this.isValidFormat());
        }

        public void removeUpdate(DocumentEvent e) {
            this.m_ApplyButton.setEnabled(this.isValidFormat());
        }
    }
}

