/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.ClassDiscovery;
import weka.core.DenseInstance;
import weka.core.Instances;
import weka.core.MultiInstanceCapabilitiesHandler;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class TestInstances
implements Cloneable,
Serializable,
OptionHandler,
RevisionHandler {
    private static final long serialVersionUID = -6263968936330390469L;
    public static final int CLASS_IS_LAST = -1;
    public static final int NO_CLASS = -2;
    public static final String[] DEFAULT_WORDS = new String[]{"The", "quick", "brown", "fox", "jumps", "over", "the", "lazy", "dog"};
    public static final String DEFAULT_SEPARATORS = " ";
    protected String[] m_Words = DEFAULT_WORDS;
    protected String m_WordSeparators = " ";
    protected String m_Relation = "Testdata";
    protected int m_Seed = 1;
    protected Random m_Random = new Random(this.m_Seed);
    protected int m_NumInstances = 20;
    protected int m_ClassType = 1;
    protected int m_NumClasses = 2;
    protected int m_ClassIndex = -1;
    protected int m_NumNominal = 1;
    protected int m_NumNominalValues = 2;
    protected int m_NumNumeric = 0;
    protected int m_NumString = 0;
    protected int m_NumDate = 0;
    protected int m_NumRelational = 0;
    protected int m_NumRelationalNominal = 1;
    protected int m_NumRelationalNominalValues = 2;
    protected int m_NumRelationalNumeric = 0;
    protected int m_NumRelationalString = 0;
    protected int m_NumRelationalDate = 0;
    protected boolean m_MultiInstance = false;
    protected int m_NumInstancesRelational = 10;
    protected Instances[] m_RelationalFormat = null;
    protected Instances m_RelationalClassFormat = null;
    protected Instances m_Data = null;
    protected CapabilitiesHandler m_Handler = null;

    public TestInstances() {
        this.setRelation("Testdata");
        this.setSeed(1);
        this.setNumInstances(20);
        this.setClassType(1);
        this.setNumClasses(2);
        this.setClassIndex(-1);
        this.setNumNominal(1);
        this.setNumNominalValues(2);
        this.setNumNumeric(0);
        this.setNumString(0);
        this.setNumDate(0);
        this.setNumRelational(0);
        this.setNumRelationalNominal(1);
        this.setNumRelationalNominalValues(2);
        this.setNumRelationalNumeric(0);
        this.setNumRelationalString(0);
        this.setNumRelationalDate(0);
        this.setNumInstancesRelational(10);
        this.setMultiInstance(false);
        this.setWords(TestInstances.arrayToList(DEFAULT_WORDS));
        this.setWordSeparators(DEFAULT_SEPARATORS);
    }

    public Object clone() {
        TestInstances result = new TestInstances();
        result.assign(this);
        return result;
    }

    public void assign(TestInstances t) {
        this.setRelation(t.getRelation());
        this.setSeed(t.getSeed());
        this.setNumInstances(t.getNumInstances());
        this.setClassType(t.getClassType());
        this.setNumClasses(t.getNumClasses());
        this.setClassIndex(t.getClassIndex());
        this.setNumNominal(t.getNumNominal());
        this.setNumNominalValues(t.getNumNominalValues());
        this.setNumNumeric(t.getNumNumeric());
        this.setNumString(t.getNumString());
        this.setNumDate(t.getNumDate());
        this.setNumRelational(t.getNumRelational());
        this.setNumRelationalNominal(t.getNumRelationalNominal());
        this.setNumRelationalNominalValues(t.getNumRelationalNominalValues());
        this.setNumRelationalNumeric(t.getNumRelationalNumeric());
        this.setNumRelationalString(t.getNumRelationalString());
        this.setNumRelationalDate(t.getNumRelationalDate());
        this.setMultiInstance(t.getMultiInstance());
        for (int i = 0; i < t.getNumRelational(); ++i) {
            this.setRelationalFormat(i, t.getRelationalFormat(i));
        }
        this.setRelationalClassFormat(t.getRelationalClassFormat());
        this.setNumInstancesRelational(t.getNumInstancesRelational());
        this.setWords(t.getWords());
        this.setWordSeparators(t.getWordSeparators());
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.add(new Option("\tThe name of the data set.", "relation", 1, "-relation <name>"));
        result.add(new Option("\tThe seed value.", "seed", 1, "-seed <num>"));
        result.add(new Option("\tThe number of instances in the datasets (default 20).", "num-instances", 1, "-num-instances <num>"));
        result.add(new Option("\tThe class type, see constants in weka.core.Attribute\n\t(default 1=nominal).", "class-type", 1, "-class-type <num>"));
        result.add(new Option("\tThe number of classes to generate (for nominal classes only)\n\t(default 2).", "class-values", 1, "-class-values <num>"));
        result.add(new Option("\tThe class index, with -1=last, (default -1).", "class-index", 1, "-class-index <num>"));
        result.add(new Option("\tDoesn't include a class attribute in the output.", "no-class", 0, "-no-class"));
        result.add(new Option("\tThe number of nominal attributes (default 1).", "nominal", 1, "-nominal <num>"));
        result.add(new Option("\tThe number of values for nominal attributes (default 2).", "nominal-values", 1, "-nominal-values <num>"));
        result.add(new Option("\tThe number of numeric attributes (default 0).", "numeric", 1, "-numeric <num>"));
        result.add(new Option("\tThe number of string attributes (default 0).", "string", 1, "-string <num>"));
        result.add(new Option("\tThe words to use in string attributes.", "words", 1, "-words <comma-separated-list>"));
        result.add(new Option("\tThe word separators to use in string attributes.", "word-separators", 1, "-word-separators <chars>"));
        result.add(new Option("\tThe number of date attributes (default 0).", "date", 1, "-date <num>"));
        result.add(new Option("\tThe number of relational attributes (default 0).", "relational", 1, "-relational <num>"));
        result.add(new Option("\tThe number of nominal attributes in a rel. attribute (default 1).", "relational-nominal", 1, "-relational-nominal <num>"));
        result.add(new Option("\tThe number of values for nominal attributes in a rel. attribute (default 2).", "relational-nominal-values", 1, "-relational-nominal-values <num>"));
        result.add(new Option("\tThe number of numeric attributes in a rel. attribute (default 0).", "relational-numeric", 1, "-relational-numeric <num>"));
        result.add(new Option("\tThe number of string attributes in a rel. attribute (default 0).", "relational-string", 1, "-relational-string <num>"));
        result.add(new Option("\tThe number of date attributes in a rel. attribute (default 0).", "relational-date", 1, "-relational-date <num>"));
        result.add(new Option("\tThe number of instances in relational/bag attributes (default 10).", "num-instances-relational", 1, "-num-instances-relational <num>"));
        result.add(new Option("\tGenerates multi-instance data.", "multi-instance", 0, "-multi-instance"));
        result.add(new Option("\tThe Capabilities handler to base the dataset on.\n\tThe other parameters can be used to override the ones\n\tdetermined from the handler. Additional parameters for\n\thandler can be passed on after the '--'.", "W", 1, "-W <classname>"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        boolean initialized = false;
        String tmpStr = Utils.getOption('W', options);
        if (tmpStr.length() > 0) {
            Class<?> cls = Class.forName(tmpStr);
            if (ClassDiscovery.hasInterface(CapabilitiesHandler.class, cls)) {
                initialized = true;
                CapabilitiesHandler handler = (CapabilitiesHandler)cls.newInstance();
                if (handler instanceof OptionHandler) {
                    ((OptionHandler)((Object)handler)).setOptions(Utils.partitionOptions(options));
                }
                this.setHandler(handler);
                this.assign(TestInstances.forCapabilities(handler.getCapabilities()));
            } else {
                throw new IllegalArgumentException("Class '" + tmpStr + "' is not a CapabilitiesHandler!");
            }
        }
        if ((tmpStr = Utils.getOption("relation", options)).length() != 0) {
            this.setRelation(tmpStr);
        } else if (!initialized) {
            this.setRelation("Testdata");
        }
        tmpStr = Utils.getOption("seed", options);
        if (tmpStr.length() != 0) {
            this.setSeed(Integer.parseInt(tmpStr));
        } else if (!initialized) {
            this.setSeed(1);
        }
        tmpStr = Utils.getOption("num-instances", options);
        if (tmpStr.length() != 0) {
            this.setNumInstances(Integer.parseInt(tmpStr));
        } else if (!initialized) {
            this.setNumInstances(20);
        }
        this.setNoClass(Utils.getFlag("no-class", options));
        if (!this.getNoClass()) {
            tmpStr = Utils.getOption("class-type", options);
            if (tmpStr.length() != 0) {
                this.setClassType(Integer.parseInt(tmpStr));
            } else if (!initialized) {
                this.setClassType(1);
            }
            tmpStr = Utils.getOption("class-values", options);
            if (tmpStr.length() != 0) {
                this.setNumClasses(Integer.parseInt(tmpStr));
            } else if (!initialized) {
                this.setNumClasses(2);
            }
            tmpStr = Utils.getOption("class-index", options);
            if (tmpStr.length() != 0) {
                this.setClassIndex(Integer.parseInt(tmpStr));
            } else if (!initialized) {
                this.setClassIndex(-1);
            }
        }
        if ((tmpStr = Utils.getOption("nominal", options)).length() != 0) {
            this.setNumNominal(Integer.parseInt(tmpStr));
        } else if (!initialized) {
            this.setNumNominal(1);
        }
        tmpStr = Utils.getOption("nominal-values", options);
        if (tmpStr.length() != 0) {
            this.setNumNominalValues(Integer.parseInt(tmpStr));
        } else if (!initialized) {
            this.setNumNominalValues(2);
        }
        tmpStr = Utils.getOption("numeric", options);
        if (tmpStr.length() != 0) {
            this.setNumNumeric(Integer.parseInt(tmpStr));
        } else if (!initialized) {
            this.setNumNumeric(0);
        }
        tmpStr = Utils.getOption("string", options);
        if (tmpStr.length() != 0) {
            this.setNumString(Integer.parseInt(tmpStr));
        } else if (!initialized) {
            this.setNumString(0);
        }
        tmpStr = Utils.getOption("words", options);
        if (tmpStr.length() != 0) {
            this.setWords(tmpStr);
        } else if (!initialized) {
            this.setWords(TestInstances.arrayToList(DEFAULT_WORDS));
        }
        if (Utils.getOptionPos("word-separators", options) > -1) {
            tmpStr = Utils.getOption("word-separators", options);
            this.setWordSeparators(tmpStr);
        } else if (!initialized) {
            this.setWordSeparators(DEFAULT_SEPARATORS);
        }
        tmpStr = Utils.getOption("date", options);
        if (tmpStr.length() != 0) {
            this.setNumDate(Integer.parseInt(tmpStr));
        } else if (!initialized) {
            this.setNumDate(0);
        }
        tmpStr = Utils.getOption("relational", options);
        if (tmpStr.length() != 0) {
            this.setNumRelational(Integer.parseInt(tmpStr));
        } else if (!initialized) {
            this.setNumRelational(0);
        }
        tmpStr = Utils.getOption("relational-nominal", options);
        if (tmpStr.length() != 0) {
            this.setNumRelationalNominal(Integer.parseInt(tmpStr));
        } else if (!initialized) {
            this.setNumRelationalNominal(1);
        }
        tmpStr = Utils.getOption("relational-nominal-values", options);
        if (tmpStr.length() != 0) {
            this.setNumRelationalNominalValues(Integer.parseInt(tmpStr));
        } else if (!initialized) {
            this.setNumRelationalNominalValues(2);
        }
        tmpStr = Utils.getOption("relational-numeric", options);
        if (tmpStr.length() != 0) {
            this.setNumRelationalNumeric(Integer.parseInt(tmpStr));
        } else if (!initialized) {
            this.setNumRelationalNumeric(0);
        }
        tmpStr = Utils.getOption("relational-string", options);
        if (tmpStr.length() != 0) {
            this.setNumRelationalString(Integer.parseInt(tmpStr));
        } else if (!initialized) {
            this.setNumRelationalString(0);
        }
        tmpStr = Utils.getOption("num-instances-relational", options);
        if (tmpStr.length() != 0) {
            this.setNumInstancesRelational(Integer.parseInt(tmpStr));
        } else if (!initialized) {
            this.setNumInstancesRelational(10);
        }
        if (!initialized) {
            this.setMultiInstance(Utils.getFlag("multi-instance", options));
        }
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-relation");
        result.add(this.getRelation());
        result.add("-seed");
        result.add("" + this.getSeed());
        result.add("-num-instances");
        result.add("" + this.getNumInstances());
        if (this.getNoClass()) {
            result.add("-no-class");
        } else {
            result.add("-class-type");
            result.add("" + this.getClassType());
            result.add("-class-values");
            result.add("" + this.getNumClasses());
            result.add("-class-index");
            result.add("" + this.getClassIndex());
        }
        result.add("-nominal");
        result.add("" + this.getNumNominal());
        result.add("-nominal-values");
        result.add("" + this.getNumNominalValues());
        result.add("-numeric");
        result.add("" + this.getNumNumeric());
        result.add("-string");
        result.add("" + this.getNumString());
        result.add("-words");
        result.add("" + this.getWords());
        result.add("-word-separators");
        result.add("" + this.getWordSeparators());
        result.add("-date");
        result.add("" + this.getNumDate());
        result.add("-relational");
        result.add("" + this.getNumRelational());
        result.add("-relational-nominal");
        result.add("" + this.getNumRelationalNominal());
        result.add("-relational-nominal-values");
        result.add("" + this.getNumRelationalNominalValues());
        result.add("-relational-numeric");
        result.add("" + this.getNumRelationalNumeric());
        result.add("-relational-string");
        result.add("" + this.getNumRelationalString());
        result.add("-relational-date");
        result.add("" + this.getNumRelationalDate());
        result.add("-num-instances-relational");
        result.add("" + this.getNumInstancesRelational());
        if (this.getMultiInstance()) {
            result.add("-multi-instance");
        }
        if (this.getHandler() != null) {
            result.add("-W");
            result.add(this.getHandler().getClass().getName());
            if (this.getHandler() instanceof OptionHandler) {
                result.add("--");
                String[] options = ((OptionHandler)((Object)this.getHandler())).getOptions();
                for (int i = 0; i < options.length; ++i) {
                    result.add(options[i]);
                }
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public void setRelation(String value) {
        this.m_Relation = value;
    }

    public String getRelation() {
        return this.m_Relation;
    }

    public void setSeed(int value) {
        this.m_Seed = value;
        this.m_Random = new Random(this.m_Seed);
    }

    public int getSeed() {
        return this.m_Seed;
    }

    public void setNumInstances(int value) {
        this.m_NumInstances = value;
    }

    public int getNumInstances() {
        return this.m_NumInstances;
    }

    public void setClassType(int value) {
        this.m_ClassType = value;
        this.m_RelationalClassFormat = null;
    }

    public int getClassType() {
        return this.m_ClassType;
    }

    public void setNumClasses(int value) {
        this.m_NumClasses = value;
    }

    public int getNumClasses() {
        return this.m_NumClasses;
    }

    public void setClassIndex(int value) {
        this.m_ClassIndex = value;
    }

    public int getClassIndex() {
        return this.m_ClassIndex;
    }

    public void setNoClass(boolean value) {
        if (value) {
            this.setClassIndex(-2);
        } else {
            this.setClassIndex(-1);
        }
    }

    public boolean getNoClass() {
        return this.getClassIndex() == -2;
    }

    public void setNumNominal(int value) {
        this.m_NumNominal = value;
    }

    public int getNumNominal() {
        return this.m_NumNominal;
    }

    public void setNumNominalValues(int value) {
        this.m_NumNominalValues = value;
    }

    public int getNumNominalValues() {
        return this.m_NumNominalValues;
    }

    public void setNumNumeric(int value) {
        this.m_NumNumeric = value;
    }

    public int getNumNumeric() {
        return this.m_NumNumeric;
    }

    public void setNumString(int value) {
        this.m_NumString = value;
    }

    public int getNumString() {
        return this.m_NumString;
    }

    protected static String[] listToArray(String value) {
        Vector<String> list = new Vector<String>();
        StringTokenizer tok = new StringTokenizer(value, ",");
        while (tok.hasMoreTokens()) {
            list.add(tok.nextToken());
        }
        return list.toArray(new String[list.size()]);
    }

    protected static String arrayToList(String[] value) {
        String result = "";
        for (int i = 0; i < value.length; ++i) {
            if (i > 0) {
                result = result + ",";
            }
            result = result + value[i];
        }
        return result;
    }

    public void setWords(String value) {
        if (TestInstances.listToArray(value).length < 2) {
            throw new IllegalArgumentException("At least 2 words must be provided!");
        }
        this.m_Words = TestInstances.listToArray(value);
    }

    public String getWords() {
        return TestInstances.arrayToList(this.m_Words);
    }

    public void setWordSeparators(String value) {
        this.m_WordSeparators = value;
    }

    public String getWordSeparators() {
        return this.m_WordSeparators;
    }

    public void setNumDate(int value) {
        this.m_NumDate = value;
    }

    public int getNumDate() {
        return this.m_NumDate;
    }

    public void setNumRelational(int value) {
        this.m_NumRelational = value;
        this.m_RelationalFormat = new Instances[value];
    }

    public int getNumRelational() {
        return this.m_NumRelational;
    }

    public void setNumRelationalNominal(int value) {
        this.m_NumRelationalNominal = value;
    }

    public int getNumRelationalNominal() {
        return this.m_NumRelationalNominal;
    }

    public void setNumRelationalNominalValues(int value) {
        this.m_NumRelationalNominalValues = value;
    }

    public int getNumRelationalNominalValues() {
        return this.m_NumRelationalNominalValues;
    }

    public void setNumRelationalNumeric(int value) {
        this.m_NumRelationalNumeric = value;
    }

    public int getNumRelationalNumeric() {
        return this.m_NumRelationalNumeric;
    }

    public void setNumRelationalString(int value) {
        this.m_NumRelationalString = value;
    }

    public int getNumRelationalString() {
        return this.m_NumRelationalString;
    }

    public void setNumRelationalDate(int value) {
        this.m_NumRelationalDate = value;
    }

    public int getNumRelationalDate() {
        return this.m_NumRelationalDate;
    }

    public void setNumInstancesRelational(int value) {
        this.m_NumInstancesRelational = value;
    }

    public int getNumInstancesRelational() {
        return this.m_NumInstancesRelational;
    }

    public void setMultiInstance(boolean value) {
        this.m_MultiInstance = value;
    }

    public boolean getMultiInstance() {
        return this.m_MultiInstance;
    }

    public void setRelationalFormat(int index, Instances value) {
        this.m_RelationalFormat[index] = value != null ? new Instances(value, 0) : null;
    }

    public Instances getRelationalFormat(int index) {
        return this.m_RelationalFormat[index];
    }

    public void setRelationalClassFormat(Instances value) {
        this.m_RelationalClassFormat = value != null ? new Instances(value, 0) : null;
    }

    public Instances getRelationalClassFormat() {
        return this.m_RelationalClassFormat;
    }

    public int getNumAttributes() {
        int result = this.m_NumNominal + this.m_NumNumeric + this.m_NumString + this.m_NumDate + this.m_NumRelational;
        if (!this.getNoClass()) {
            ++result;
        }
        return result;
    }

    public Instances getData() {
        return this.m_Data;
    }

    public void setHandler(CapabilitiesHandler value) {
        this.m_Handler = value;
    }

    public CapabilitiesHandler getHandler() {
        return this.m_Handler;
    }

    protected Attribute generateAttribute(int index, int attType, String namePrefix) throws Exception {
        int nomCount;
        String prefix;
        String name;
        int valIndex;
        Attribute result = null;
        if (index == -1) {
            valIndex = 0;
            name = "Class";
            prefix = "class";
            nomCount = this.getNumClasses();
        } else {
            valIndex = index;
            nomCount = this.getNumNominalValues();
            prefix = "att" + (valIndex + 1) + "val";
            switch (attType) {
                case 1: {
                    name = "Nominal" + (valIndex + 1);
                    break;
                }
                case 0: {
                    name = "Numeric" + (valIndex + 1);
                    break;
                }
                case 2: {
                    name = "String" + (valIndex + 1);
                    break;
                }
                case 3: {
                    name = "Date" + (valIndex + 1);
                    break;
                }
                case 4: {
                    name = "Relational" + (valIndex + 1);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Attribute type '" + attType + "' unknown!");
                }
            }
        }
        switch (attType) {
            case 1: {
                ArrayList<String> nomStrings = new ArrayList<String>(valIndex + 1);
                for (int j = 0; j < nomCount; ++j) {
                    nomStrings.add(prefix + (j + 1));
                }
                result = new Attribute(namePrefix + name, nomStrings);
                break;
            }
            case 0: {
                result = new Attribute(namePrefix + name);
                break;
            }
            case 2: {
                result = new Attribute(namePrefix + name, (List<String>)null);
                break;
            }
            case 3: {
                result = new Attribute(namePrefix + name, "yyyy-mm-dd");
                break;
            }
            case 4: {
                Instances rel = index == -1 ? this.getRelationalClassFormat() : this.getRelationalFormat(index);
                if (rel == null) {
                    TestInstances dataset = new TestInstances();
                    dataset.setNumNominal(this.getNumRelationalNominal());
                    dataset.setNumNominalValues(this.getNumRelationalNominalValues());
                    dataset.setNumNumeric(this.getNumRelationalNumeric());
                    dataset.setNumString(this.getNumRelationalString());
                    dataset.setNumDate(this.getNumRelationalDate());
                    dataset.setNumInstances(0);
                    dataset.setClassType(1);
                    rel = new Instances(dataset.generate());
                    if (!this.getNoClass()) {
                        int clsIndex = rel.classIndex();
                        rel.setClassIndex(-1);
                        rel.deleteAttributeAt(clsIndex);
                    }
                }
                result = new Attribute(namePrefix + name, rel);
                break;
            }
            default: {
                throw new IllegalArgumentException("Attribute type '" + attType + "' unknown!");
            }
        }
        return result;
    }

    protected double generateClassValue(Instances data) throws Exception {
        double result = Double.NaN;
        switch (this.m_ClassType) {
            case 0: {
                result = (double)this.m_Random.nextFloat() * 0.25 + (double)(Math.abs(this.m_Random.nextInt()) % Math.max(2, this.m_NumNominal));
                break;
            }
            case 1: {
                result = Math.abs(this.m_Random.nextInt()) % data.numClasses();
                break;
            }
            case 2: {
                String str = "";
                for (int n = 0; n < this.m_Words.length; ++n) {
                    if (n > 0 && this.m_WordSeparators.length() != 0) {
                        str = str + this.m_WordSeparators.charAt(this.m_Random.nextInt(this.m_WordSeparators.length()));
                    }
                    str = str + this.m_Words[this.m_Random.nextInt(this.m_Words.length)];
                }
                result = data.classAttribute().addStringValue(str);
                break;
            }
            case 3: {
                result = data.classAttribute().parseDate(2000 + this.m_Random.nextInt(100) + "-01-01");
                break;
            }
            case 4: {
                if (this.getRelationalClassFormat() != null) {
                    result = data.classAttribute().addRelation(this.getRelationalClassFormat());
                    break;
                }
                TestInstances dataset = new TestInstances();
                dataset.setNumNominal(this.getNumRelationalNominal());
                dataset.setNumNominalValues(this.getNumRelationalNominalValues());
                dataset.setNumNumeric(this.getNumRelationalNumeric());
                dataset.setNumString(this.getNumRelationalString());
                dataset.setNumDate(this.getNumRelationalDate());
                dataset.setNumInstances(this.getNumInstancesRelational());
                dataset.setClassType(1);
                Instances rel = new Instances(dataset.generate());
                int clsIndex = rel.classIndex();
                rel.setClassIndex(-1);
                rel.deleteAttributeAt(clsIndex);
                result = data.classAttribute().addRelation(rel);
            }
        }
        return result;
    }

    protected double generateAttributeValue(Instances data, int index, double classVal) throws Exception {
        double result = Double.NaN;
        switch (data.attribute(index).type()) {
            case 0: {
                result = classVal * 4.0 + (double)(this.m_Random.nextFloat() * 1.0f) - 0.5;
                break;
            }
            case 1: {
                if ((double)this.m_Random.nextFloat() < 0.2) {
                    result = Math.abs(this.m_Random.nextInt()) % data.attribute(index).numValues();
                    break;
                }
                result = (int)classVal % data.attribute(index).numValues();
                break;
            }
            case 2: {
                String str = "";
                for (int n = 0; n < this.m_Words.length; ++n) {
                    if (n > 0 && this.m_WordSeparators.length() != 0) {
                        str = str + this.m_WordSeparators.charAt(this.m_Random.nextInt(this.m_WordSeparators.length()));
                    }
                    str = str + this.m_Words[this.m_Random.nextInt(this.m_Words.length)];
                }
                result = data.attribute(index).addStringValue(str);
                break;
            }
            case 3: {
                result = data.attribute(index).parseDate(2000 + this.m_Random.nextInt(100) + "-01-01");
                break;
            }
            case 4: {
                Instances rel = new Instances(data.attribute(index).relation(), 0);
                for (int n = 0; n < this.getNumInstancesRelational(); ++n) {
                    DenseInstance inst = new DenseInstance(rel.numAttributes());
                    inst.setDataset(data);
                    for (int i = 0; i < rel.numAttributes(); ++i) {
                        inst.setValue(i, this.generateAttributeValue(rel, i, 0.0));
                    }
                    rel.add(inst);
                }
                result = data.attribute(index).addRelation(rel);
            }
        }
        return result;
    }

    public Instances generate() throws Exception {
        return this.generate("");
    }

    public Instances generate(String namePrefix) throws Exception {
        if (this.getMultiInstance()) {
            TestInstances bag = (TestInstances)this.clone();
            bag.setMultiInstance(false);
            bag.setNumInstances(0);
            bag.setSeed(this.m_Random.nextInt());
            Instances bagFormat = bag.generate("bagAtt_");
            bagFormat.setClassIndex(-1);
            bagFormat.deleteAttributeAt(bagFormat.numAttributes() - 1);
            TestInstances structure = new TestInstances();
            structure.setSeed(this.m_Random.nextInt());
            structure.setNumNominal(1);
            structure.setNumRelational(1);
            structure.setRelationalFormat(0, bagFormat);
            structure.setClassType(this.getClassType());
            structure.setNumClasses(this.getNumClasses());
            structure.setRelationalClassFormat(this.getRelationalClassFormat());
            structure.setNumInstances(this.getNumInstances());
            this.m_Data = structure.generate();
            bag.setNumInstances(this.getNumInstancesRelational());
            for (int i = 0; i < this.getNumInstances(); ++i) {
                bag.setSeed(this.m_Random.nextInt());
                Instances bagData = new Instances(bag.generate("bagAtt_"));
                bagData.setClassIndex(-1);
                bagData.deleteAttributeAt(bagData.numAttributes() - 1);
                double val = this.m_Data.attribute(1).addRelation(bagData);
                this.m_Data.instance(i).setValue(1, val);
            }
        } else {
            int i;
            int clsIndex = this.m_ClassIndex;
            if (clsIndex == -1) {
                clsIndex = this.getNumAttributes() - 1;
            }
            ArrayList<Attribute> attributes = new ArrayList<Attribute>(this.getNumAttributes());
            for (i = 0; i < this.getNumNominal(); ++i) {
                attributes.add(this.generateAttribute(i, 1, namePrefix));
            }
            for (i = 0; i < this.getNumNumeric(); ++i) {
                attributes.add(this.generateAttribute(i, 0, namePrefix));
            }
            for (i = 0; i < this.getNumString(); ++i) {
                attributes.add(this.generateAttribute(i, 2, namePrefix));
            }
            for (i = 0; i < this.getNumDate(); ++i) {
                attributes.add(this.generateAttribute(i, 3, namePrefix));
            }
            for (i = 0; i < this.getNumRelational(); ++i) {
                attributes.add(this.generateAttribute(i, 4, namePrefix));
            }
            if (clsIndex != -2) {
                attributes.add(clsIndex, this.generateAttribute(-1, this.getClassType(), namePrefix));
            }
            this.m_Data = new Instances(this.getRelation(), attributes, this.getNumInstances());
            this.m_Data.setClassIndex(clsIndex);
            for (i = 0; i < this.getNumInstances(); ++i) {
                double classVal;
                DenseInstance current = new DenseInstance(this.getNumAttributes());
                current.setDataset(this.m_Data);
                if (clsIndex != -2) {
                    classVal = this.generateClassValue(this.m_Data);
                    current.setClassValue(classVal);
                } else {
                    classVal = this.m_Random.nextFloat();
                }
                for (int n = 0; n < this.getNumAttributes(); ++n) {
                    if (clsIndex == n) continue;
                    current.setValue(n, this.generateAttributeValue(this.m_Data, n, classVal));
                }
                this.m_Data.add(current);
            }
        }
        if (this.m_Data.classIndex() == -2) {
            this.m_Data.setClassIndex(-1);
        }
        return this.getData();
    }

    public static TestInstances forCapabilities(Capabilities c) {
        TestInstances result = new TestInstances();
        if (c.getOwner() instanceof MultiInstanceCapabilitiesHandler) {
            Capabilities multi = (Capabilities)((MultiInstanceCapabilitiesHandler)c.getOwner()).getMultiInstanceCapabilities().clone();
            multi.setOwner(null);
            result = TestInstances.forCapabilities(multi);
            result.setMultiInstance(true);
        } else {
            if (c.handles(Capabilities.Capability.NO_CLASS)) {
                result.setClassIndex(-2);
            } else if (c.handles(Capabilities.Capability.NOMINAL_CLASS)) {
                result.setClassType(1);
            } else if (c.handles(Capabilities.Capability.BINARY_CLASS)) {
                result.setClassType(1);
            } else if (c.handles(Capabilities.Capability.NUMERIC_CLASS)) {
                result.setClassType(0);
            } else if (c.handles(Capabilities.Capability.DATE_CLASS)) {
                result.setClassType(3);
            } else if (c.handles(Capabilities.Capability.STRING_CLASS)) {
                result.setClassType(2);
            } else if (c.handles(Capabilities.Capability.RELATIONAL_CLASS)) {
                result.setClassType(4);
            }
            if (c.handles(Capabilities.Capability.UNARY_CLASS)) {
                result.setNumClasses(1);
            }
            if (c.handles(Capabilities.Capability.BINARY_CLASS)) {
                result.setNumClasses(2);
            }
            if (c.handles(Capabilities.Capability.NOMINAL_CLASS)) {
                result.setNumClasses(4);
            }
            if (c.handles(Capabilities.Capability.NOMINAL_ATTRIBUTES)) {
                result.setNumNominal(1);
                result.setNumRelationalNominal(1);
            } else {
                result.setNumNominal(0);
                result.setNumRelationalNominal(0);
            }
            if (c.handles(Capabilities.Capability.NUMERIC_ATTRIBUTES)) {
                result.setNumNumeric(1);
                result.setNumRelationalNumeric(1);
            } else {
                result.setNumNumeric(0);
                result.setNumRelationalNumeric(0);
            }
            if (c.handles(Capabilities.Capability.DATE_ATTRIBUTES)) {
                result.setNumDate(1);
                result.setNumRelationalDate(1);
            } else {
                result.setNumDate(0);
                result.setNumRelationalDate(0);
            }
            if (c.handles(Capabilities.Capability.STRING_ATTRIBUTES)) {
                result.setNumString(1);
                result.setNumRelationalString(1);
            } else {
                result.setNumString(0);
                result.setNumRelationalString(0);
            }
            if (c.handles(Capabilities.Capability.RELATIONAL_ATTRIBUTES)) {
                result.setNumRelational(1);
            } else {
                result.setNumRelational(0);
            }
        }
        return result;
    }

    public String toString() {
        String result = "";
        result = result + "Relation: " + this.getRelation() + "\n";
        result = result + "Seed: " + this.getSeed() + "\n";
        result = result + "# Instances: " + this.getNumInstances() + "\n";
        result = result + "ClassType: " + this.getClassType() + "\n";
        result = result + "# Classes: " + this.getNumClasses() + "\n";
        result = result + "Class index: " + this.getClassIndex() + "\n";
        result = result + "# Nominal: " + this.getNumNominal() + "\n";
        result = result + "# Nominal values: " + this.getNumNominalValues() + "\n";
        result = result + "# Numeric: " + this.getNumNumeric() + "\n";
        result = result + "# String: " + this.getNumString() + "\n";
        result = result + "# Date: " + this.getNumDate() + "\n";
        result = result + "# Relational: " + this.getNumRelational() + "\n";
        result = result + "  - # Nominal: " + this.getNumRelationalNominal() + "\n";
        result = result + "  - # Nominal values: " + this.getNumRelationalNominalValues() + "\n";
        result = result + "  - # Numeric: " + this.getNumRelationalNumeric() + "\n";
        result = result + "  - # String: " + this.getNumRelationalString() + "\n";
        result = result + "  - # Date: " + this.getNumRelationalDate() + "\n";
        result = result + "  - # Instances: " + this.getNumInstancesRelational() + "\n";
        result = result + "Multi-Instance: " + this.getMultiInstance() + "\n";
        result = result + "Words: " + this.getWords() + "\n";
        result = result + "Word separators: " + this.getWordSeparators() + "\n";
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10203 $");
    }

    public static void main(String[] args) throws Exception {
        TestInstances inst = new TestInstances();
        if (Utils.getFlag("h", args) || Utils.getFlag("help", args)) {
            StringBuffer result = new StringBuffer();
            result.append("\nTest data generator options:\n\n");
            result.append("-h|-help\n\tprints this help\n");
            Enumeration<Option> enm = inst.listOptions();
            while (enm.hasMoreElements()) {
                Option option = enm.nextElement();
                result.append(option.synopsis() + "\n" + option.description() + "\n");
            }
            System.out.println(result);
            System.exit(0);
        }
        inst.setOptions(args);
        System.out.println(inst.generate());
    }
}

