/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class InteractiveTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -5113873323690309667L;
    public int m_hidden_index;
    protected String[] m_columnNames;
    protected List<List<String>> m_dataVector;

    public InteractiveTableModel(String[] columnNames) {
        this.m_columnNames = columnNames;
        this.m_dataVector = new ArrayList<List<String>>();
        this.m_hidden_index = columnNames.length - 1;
    }

    @Override
    public String getColumnName(int column) {
        return this.m_columnNames[column];
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column != this.m_hidden_index;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return String.class;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (column >= this.m_columnNames.length) {
            return new Object();
        }
        List<String> rowData = this.m_dataVector.get(row);
        return rowData.get(column);
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if (column >= this.m_columnNames.length) {
            System.err.println("Invalid index");
        }
        List<String> rowData = this.m_dataVector.get(row);
        rowData.set(column, value.toString());
        this.fireTableCellUpdated(row, column);
    }

    @Override
    public int getRowCount() {
        return this.m_dataVector.size();
    }

    @Override
    public int getColumnCount() {
        return this.m_columnNames.length;
    }

    public boolean hasEmptyRow() {
        if (this.m_dataVector.size() == 0) {
            return false;
        }
        List<String> dataRow = this.m_dataVector.get(this.m_dataVector.size() - 1);
        for (String s : dataRow) {
            if (s.length() == 0) continue;
            return false;
        }
        return true;
    }

    public void addEmptyRow() {
        ArrayList<String> empty = new ArrayList<String>();
        for (int i = 0; i < this.m_columnNames.length; ++i) {
            empty.add("");
        }
        this.m_dataVector.add(empty);
        this.fireTableRowsInserted(this.m_dataVector.size() - 1, this.m_dataVector.size() - 1);
    }
}

