  require(RXshrink)
  #
  # Read in the Portland Cement data.frame...
  data(haldport)
  #
  # Next, define a regression model formula...
  form <- heat~p3ca+p3cs+p4caf+p2cs
  #
  # First, perform QM (2-parameter) generalized Ridge Shrinkage...
  rxrobj <- qm.ridge(form, data=haldport)
  #
  # Display all 5 qm.ridge() TRACE Diagnostics in 1 plot...
  plot(rxrobj)
  #
  # Print qm.ridge() Summary Statistics...
  rxrobj
  # SCROLL ^^^ UP ^^^ to see PRINTED output from qm.ridge()...
  #
  # Next, results for (augmented) Least Angle Regression,
  # aug.lars(), will be PLOTTED and PRINTED...
  #
  # Perform Augmented lars() model fitting...  
  rxaobj <- aug.lars(form, data=haldport)
  #
  # Display all 5 aug.lars() TRACE Diagnostics in 1 plot...
  plot(rxaobj)
  #
  # Print Summary Statistics from aug.lars()...
  rxaobj
  # SCROLL ^^^ UP ^^^ to see PRINTED output from aug.lars()...
  #
  # Next, results from augmented lars() model fitting to the
  # Uncorrelated Components of the haldport data.frame, 
  # uc.lars(), will be PLOTTED and PRINTED...  
  #
  # Perform uc.lars() model fitting...  
  rxcobj <- uc.lars(form, data=haldport)
  #
  # Display all 5 uc.lars() TRACE Diagnostics in 1 plot...
  plot(rxcobj)
  #
  # Print Summary Statistics from uc.lars()...
  rxcobj
  # SCROLL ^^^ UP ^^^ to see PRINTED output from uc.lars()...
  #
  # Finally, results for UNRESTRICTED (p-parameter)
  # generalized ridge regression (GRR) model-fitting,
  # unr.ridge(), will be PLOTTED and PRINTED...  
  #
  # Perform unr.ridge() model fitting...  
  rxuobj <- unr.ridge(form, data=haldport)
  #
  # Display all 5 unr.ridge() TRACE Diagnostics in 1 plot...
  plot(rxuobj)
  #
  # Print Summary Statistics from unr.ridge()...  
  rxuobj
  # SCROLL ^^^ UP ^^^ to see PRINTED output from unr.ridge()...
  #
  # Did you notice how "different" the FOUR main types of GRR TRACEs
  # [qm.ridge(), aug.lars() uc.lars() and unr.ridge()] LOOK for the
  # "haldport" data.frame? These represent 4 DISTINCT Shrinkage-Paths
  # for almost any data.frame containing ill-conditioned (confounded)
  # x-variables.
  #
  #################### END of "haldport" Demo...
  