% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zooroh_accessor.R
\name{probhbd}
\alias{probhbd}
\title{Extracts the HBD probabilities from the zres object}
\usage{
probhbd(zres, zooin, id, chrom = NULL, startPos = NULL,
  endPos = NULL, T = FALSE)
}
\arguments{
\item{zres}{The name of the zres object created by the zoorun function.}

\item{zooin}{The name of the zdata object created by the zoodata function. See
"zoodata" for more details.}

\item{id}{The number of the individual to extract.}

\item{chrom}{the number of the chromosome where we are looking for HBD segments.
This chromosome number refers to the position of the chromosome in the list
of all chromsomes present in the input genotype data.}

\item{startPos}{The starting position (on the chromosome) of the interval from which we will extract HBD segments
(1 by default).}

\item{endPos}{The ending position (on the chromosome) of the interval from which we will extract HBD segments
(last position by default).}

\item{T}{The value chosen to define the base population (to determine which classes are used in estimated of HBD
probability, which classes are considered autozygous). When T is not provided, all HBD classes
are considered to estimate the local HBD probability.}
}
\value{
The function returns a vector of HBD probabilities for the specified individual and chromosomal region.
The HBD probabilities are computed as the sum of the probabilities for each HBD class with a rate smaller or equal than
the threshold (the sum from all the HBD classes when T is not specified).
}
\description{
Extracts the locus specific HBD probabilities for an individual. A specific chromosomal region can be specified.
A threshold T can be used to determine which HBD classes are used in the computation of the HBD probability.
}
