% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RaceID.R
\name{filterdata}
\alias{filterdata}
\title{Data filtering}
\usage{
filterdata(object, mintotal = 3000, minexpr = 5, minnumber = 5,
  LBatch = NULL, knn = 10, CGenes = NULL, FGenes = NULL, ccor = 0.4,
  bmode = "RaceID", verbose = TRUE)
}
\arguments{
\item{object}{\code{SCseq} class object.}

\item{mintotal}{minimum total transcript number required. Cells with less than \code{mintotal} transcripts are filtered out. Default is 3000.}

\item{minexpr}{minimum required transcript count of a gene in at least \code{minnumber} cells. All other genes are filtered out. Default is 5.}

\item{minnumber}{See \code{minexpr}. Default is 5.}

\item{LBatch}{List of experimental batches used for batch effect correction. Each list element contains a vector with cell names
(i.e. column names of the input expression data) falling into this batch. Default is \code{NULL}, i.e. no batch correction.}

\item{knn}{Number of nearest neighbors used to infer corresponding cell types in different batches. Defult is 10.}

\item{CGenes}{List of gene names. All genes with correlated expression to any of the genes in \code{CGenes} are filtered out for cell type inference.
Default is \code{NULL}.}

\item{FGenes}{List of gene names to be filtered out for cell type inference. Default is \code{NULL}.}

\item{ccor}{Correlation coefficient used as a trehshold for determining genes correlated to genes in \code{CGenes}.
Only genes correlating  less than \code{ccor} to all genes in \code{CGenes} are retained for analysis. Default is 0.4.}

\item{bmode}{Method used for batch effect correction. Any of \code{"RaceID","scran"}. Default is \code{"RaceID"}.}

\item{verbose}{logical. If \code{FALSE} then status output messages are disabled. Default is \code{TRUE}.}
}
\value{
An SCseq class object with filtered and normalized expression data.
}
\description{
This function allows filtering of genes and cells to be used in the RaceID3 analysis.
It also can perform batch effect correction using an internal method or a recently published alternative \code{mnnCorrect} from the \pkg{scran} package.
}
\examples{
sc <- SCseq(intestinalDataSmall)
sc <- filterdata(sc)
}
