% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarID_functions.R
\name{graphCluster}
\alias{graphCluster}
\title{Function for infering Louvain clustering of the pruned k nearest neighbour graph}
\usage{
graphCluster(res, pvalue = 0.01, use.weights = TRUE, rseed = 12345)
}
\arguments{
\item{res}{List object with k nearest neighbour information returned by \code{pruneKnn} function.}

\item{pvalue}{Positive real number between 0 and 1. All nearest neighbours with link probability \code{< pvalue} are discarded. Default is 0.01.}

\item{use.weights}{logical. If TRUE, then nearest-neighbor link probabilities are used to build a graph as input for Louvain clustering. If FALSE, then all links have equal weight. Default is TRUE.}

\item{rseed}{Integer number. Random seed to enforce reproducible clustering results. Default is 12345.}
}
\value{
List object of three components:
\item{graph}{graph derived from the pruned adjacency matrix computed with the \pkg{igraph} package.}
\item{louvain}{Louvain clustering returned by the cluster_louvain function from the \pkg{igraph} package.}
\item{fr}{Fruchterman-Rheingold graph layout derived from the pruned adjacency matrix.}
}
\description{
This function derives a graph object from the pruned nearest neighbours and infers clusters by the the Louvain clustering method on this graph.
A Fruchterman-Rheingold graph layout is also derived from the pruned nearest neighbours.
}
\examples{
res <- pruneKnn(intestinalDataSmall,metric="pearson",knn=10,alpha=1,no_cores=1,FSelect=FALSE)
cl <- graphCluster(res,pvalue=0.01)
}
