% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_stress.R
\name{pointStress}
\alias{pointStress}
\alias{agStress}
\alias{srStress}
\alias{srStressPerTiter}
\alias{agStressPerTiter}
\title{Get individual point stress}
\usage{
agStress(map, antigens = TRUE, optimization_number = 1)

srStress(map, sera = TRUE, optimization_number = 1)

srStressPerTiter(map, sera = TRUE, optimization_number = 1)

agStressPerTiter(map, antigens = TRUE, optimization_number = 1)
}
\arguments{
\item{map}{The acmap data object}

\item{antigens}{Which antigens to check stress for, specified by index or
name (defaults to all antigens).}

\item{optimization_number}{The optimization number}

\item{sera}{Which sera to check stress for, specified by index or name
(defaults to all sera).}
}
\value{
A numeric vector of point stresses
}
\description{
Functions to get stress associated with individual points in a map.
}
\seealso{
See \code{mapStress()} for getting the total map stress directly.

Other map diagnostic functions: 
\code{\link{agCohesion}()},
\code{\link{bootstrapBlobs}()},
\code{\link{bootstrapMap}()},
\code{\link{checkHemisphering}()},
\code{\link{dimensionTestMap}()},
\code{\link{logtiterTable}()},
\code{\link{map-table-distances}},
\code{\link{mapBootstrapCoords}},
\code{\link{mapDistances}()},
\code{\link{mapRelaxed}()},
\code{\link{mapResiduals}()},
\code{\link{ptBootstrapBlob}},
\code{\link{ptBootstrapCoords}()},
\code{\link{ptLeverage}},
\code{\link{ptTriangulationBlob}},
\code{\link{recalculateStress}()},
\code{\link{stressTable}()},
\code{\link{tableColbases}()},
\code{\link{tableDistances}()},
\code{\link{triangulationBlobs}()},
\code{\link{unstableMaps}}

Other functions relating to map stress calculation: 
\code{\link{logtiterTable}()},
\code{\link{mapDistances}()},
\code{\link{mapResiduals}()},
\code{\link{recalculateStress}()},
\code{\link{stressTable}()},
\code{\link{tableColbases}()},
\code{\link{tableDistances}()}
}
\concept{functions relating to map stress calculation}
\concept{map diagnostic functions}
