% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{generate_caption}
\alias{generate_caption}
\title{Helper function to generate a caption string based on provided attributes}
\usage{
generate_caption(attributes)
}
\arguments{
\item{attributes}{A list containing various attributes that may include
\code{dimension}, \code{num_steps}, \code{mu}, and \code{sd}.}
}
\value{
A character string representing the generated caption. If no
attributes are provided, it returns an empty string.
}
\description{
Generates a caption string based on provided attributes.
}
\details{
This function is useful for creating descriptive captions for
plots or outputs based on the attributes provided. It ensures that only
non-null attributes are included in the caption. This function constructs a
caption string by checking various attributes provided in a list.
It formats the caption based on the presence of specific attributes, such as
dimensions, number of steps, and statistical parameters like mu and standard
deviation (sd).
}
\examples{
attrs <- list(dimension = 3, num_steps = 100, mu = 0.5, sd = 1.2)
generate_caption(attrs) # "3 dimensions, 100 steps, mu = 0.5, sd = 1.2."

attrs <- list(dimension = NULL, num_steps = 50, mu = NULL, sd = 2.0)
generate_caption(attrs) # "50 steps, sd = 2.0."

}
\seealso{
Other Utility Functions: 
\code{\link{convert_snake_to_title_case}()},
\code{\link{get_attributes}()},
\code{\link{rand_walk_helper}()},
\code{\link{running_quantile}()},
\code{\link{std_cum_max_augment}()},
\code{\link{std_cum_mean_augment}()},
\code{\link{std_cum_min_augment}()},
\code{\link{std_cum_prod_augment}()},
\code{\link{std_cum_sum_augment}()}
}
\author{
Antti Lennart Rask
}
\concept{Utility Functions}
