% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_download.R
\name{rvn_download}
\alias{rvn_download}
\title{Downloads Raven}
\usage{
rvn_download(version = NA, NetCDF = FALSE, check = FALSE)
}
\arguments{
\item{version}{(optional) Character: The version of Raven to be downloaded. If not provided, the latest version will be downloaded.}

\item{NetCDF}{(logical) whether to download the NetCDF-enabled version of Raven (default \code{FALSE})}

\item{check}{(logical) if \code{TRUE}, function will only check whether 'Raven.exe' has been downloaded to the RavenR folder}
}
\value{
Returns \code{TRUE} if executed successfully
}
\description{
Downloads Raven executable from the \href{http://raven.uwaterloo.ca/Downloads.html}{Raven webpage}.
}
\details{
Files are downloaded from the Raven webpage (\url{http://raven.uwaterloo.ca/Downloads.html}) and placed
in a temporary directory while the executable is extracted. This helps prevent any unwanted files being
saved on your system outside of temporary directories if the function is interrupted. The executable is placed in the
RavenR/extdata directory, wherever RavenR is installed on your system.

Note that if you are not on a Windows operating system, you may need to compile Raven for your system rather than

Any existing Raven.exe file in your RavenR/extdata folder will be overwritten with a newly downloaded executable w
with this function.

Reinstalling the RavenR package removes the previous files in the RavenR/ folder on your system, so this command
will need to be re-run if RavenR is re-installed.

Once downloaded, the Raven.exe file can be found with \code{system.file("extdata", "Raven.exe", package="RavenR")}
}
\examples{

# check if Raven.exe has previously been downloaded
rvn_download(check=TRUE)

\dontrun{
## NOT RUN (downloads executable)

# download latest without netcdf support
rvn_download()

# download specific version with netcdf support
rvn_download(version="3.0.4",NetCDF=TRUE)

# find file path to Raven.exe
system.file("extdata", "Raven.exe", package="RavenR")
}

}
\seealso{
\code{\link{rvn_run}}
}
