% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleView.R
\name{plotSampleFeatures}
\alias{plotSampleFeatures}
\title{2D-features scatter-plot}
\usage{
plotSampleFeatures(
  data,
  label,
  parH = NULL,
  parV = NULL,
  figure.title = "Scatter plot",
  logscale = "",
  cex = 0.8,
  point.param = expand.grid(col = c("grey", "black", "red", "blue", "green", "cyan",
    "yellow", "orange", "rosybrown", "palevioletred", "darkblue", "deeppink",
    "blueviolet", "darkgoldenrod1", "chartreuse", "darkorchid1", "deeppink", "coral",
    "darkolivegreen1", "#66C2A5", "#9DAE8C", "#D49A73", "#F08F6D", "#C79693", "#9E9DBA",
    "#9F9BC9", "#C193C6", "#E28BC3", "#D2A29F", "#BABF77", "#AAD852", "#CBD844",
    "#ECD836", "#FAD53E", "#F1CD64", "#E7C689", "#D7BF9C", "#C5B9A7", "#B3B3B3",
    "#D53E4F", "#E04F4A", "#EB6046", "#F47346", 
     "#F88B51", "#FBA35C", "#FDB869",
    "#FDCA79", "#FDDD88", "#F6E68F", "#EDEE93", "#E2F398", "#CDEA9D", "#B7E2A1",
    "#A0D8A4", "#86CEA4", "#6DC4A4", "#58B2AB", "#459DB4", "#3288BD"), pch = c(20, 0:18),
    stringsAsFactors = FALSE),
  env.plot = NULL
)
}
\arguments{
\item{data}{matrix or data.frame of raw data (points by line).}

\item{label}{vector of labels.}

\item{parH}{character vector specifying the name of the feature to use as x-axis.}

\item{parV}{character vector specifying the name of the feature to use as y-axis.}

\item{figure.title}{character vector specifying the title of the scatter-plot.}

\item{logscale}{character vector containing "x" if the x-axis is to be logarithmic, "y" if the y-axis is to be logarithmic and "xy" or "yx" if both axes are to be logarithmic.}

\item{cex}{numeric value specifying the size of the graphical labels.}

\item{point.param}{data.frame specifying the colors and the symbols to use for clusters display.}

\item{env.plot}{environment where to store graphical parameters used by function PlotScatter to select points.}
}
\value{
None
}
\description{
Plot 2D-features scatter-plot of all particles. Grey color (label=0) is for data to cleaned or to remove in classification process.
}
\details{
plotSampleFeatures plots 2D-features scatter-plot of all particles
}
\examples{
dat <- rbind(matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 6, sd = 0.3), ncol = 2))
colnames(dat) <- c("x","y")
tf1 <- tempfile()
write.table(dat, tf1, sep=",", dec=".")

sig <- data.frame(ID=rep(1:150, each=30), SIGNAL=rep(dnorm(seq(-2,2,length=30)),150))
tf2 <- tempfile()
write.table(sig, tf2, sep=",", dec=".")

x <- importSample(file.features=tf1, file.profiles=tf2)

res <- KmeansQuick(x$features$initial$x, K=3)
new.labels <- formatLabelSample(res$cluster, x)

plotSampleFeatures(x$features$initial$x, label = new.labels, parH="x", parV="y")


}
\seealso{
\code{\link{plotProfile}}, \code{\link{visualizeSampleClustering}}
}
\keyword{internal}
