# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

example0 <- function() {
    invisible(.Call('RcppCCTZ_example0', PACKAGE = 'RcppCCTZ'))
}

helloMoon <- function() {
    .Call('RcppCCTZ_helloMoon', PACKAGE = 'RcppCCTZ')
}

example1 <- function() {
    invisible(.Call('RcppCCTZ_example1', PACKAGE = 'RcppCCTZ'))
}

example2 <- function() {
    .Call('RcppCCTZ_example2', PACKAGE = 'RcppCCTZ')
}

example3 <- function() {
    invisible(.Call('RcppCCTZ_example3', PACKAGE = 'RcppCCTZ'))
}

example4 <- function() {
    invisible(.Call('RcppCCTZ_example4', PACKAGE = 'RcppCCTZ'))
}

exampleFormat <- function() {
    invisible(.Call('RcppCCTZ_exampleFormat', PACKAGE = 'RcppCCTZ'))
}

#' Difference between two given timezones at a specified date.
#'
#' Time zone offsets vary by date, and this helper function computes
#' the difference (in hours) between two time zones for a given date time.
#'
#' @title Return difference between two time zones at a given date.
#' @param tzfrom The first time zone as a character vector.
#' @param tzto The second time zone as a character vector.
#' @param dt A Datetime object specifying when the difference is to be computed.
#' @param verbose A boolean toggle indicating whether more verbose operations
#' are desired, default is \code{FALSE}.
#' @return A numeric value with the difference (in hours) between the first and
#' second time zone at the given date
#' @author Dirk Eddelbuettel
#' @examples
#' # simple call: difference now
#' tzDiff("America/New_York", "Europe/London", Sys.time())
#' # tabulate difference for every week of the year
#' table(sapply(0:52, function(d) tzDiff("America/New_York", "Europe/London",
#'                                       as.POSIXct(as.Date("2016-01-01") + d*7))))
tzDiff <- function(tzfrom, tzto, dt, verbose = FALSE) {
    .Call('RcppCCTZ_tzDiff', PACKAGE = 'RcppCCTZ', tzfrom, tzto, dt, verbose)
}

#' Change from one given timezone to another.
#'
#' Time zone offsets vary by date, and this helper function converts
#' a Datetime object from one given timezone to another.
#'
#' @title Return difference between two time zones at a given date.
#' @param dt A Datetime object specifying when the difference is to be computed.
#' @param tzfrom The first time zone as a character vector.
#' @param tzto The second time zone as a character vector.
#' @param verbose A boolean toggle indicating whether more verbose operations
#' are desired, default is \code{FALSE}.
#' @return A Datetime object with the given (civil time) determined by the
#' incoming object (and its timezone) shifted to the target timezone.
#' @author Dirk Eddelbuettel
#' @examples
#' toTz(Sys.time(), "America/New_York", "Europe/London")
toTz <- function(dt, tzfrom, tzto, verbose = FALSE) {
    .Call('RcppCCTZ_toTz', PACKAGE = 'RcppCCTZ', dt, tzfrom, tzto, verbose)
}

