% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{checkXPtr}
\alias{checkXPtr}
\title{Check an \code{XPtr}'s Signature}
\usage{
checkXPtr(ptr, type, args = character(), call. = TRUE)
}
\arguments{
\item{ptr}{an object of class \code{XPtr} compiled with \code{\link{cppXPtr}}.}

\item{type}{the return type.}

\item{args}{a list of argument types.}

\item{call.}{logical, indicating if the call should become part of the error message.}
}
\description{
Check the signature (i.e., arguments and return type) of the output of
\code{\link{cppXPtr}}, which is an external pointer wrapped in an object of
class \code{XPtr}. If the user-supplied C++ function does not match the
signature, the wrapper throws an informative error.
}
\examples{
\donttest{
# takes time to compile
ptr <- cppXPtr("double foo(int a, double b) { return a + b; }")
checkXPtr(ptr, "double", c("int", "double")) # returns silently
checkXPtr(ptr, "int", c("double", "std::string")) # throws error
}
}
\seealso{
\code{\link{cppXPtr}}
}
