% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReferenceManual.R
\name{ReferenceManual}
\alias{ReferenceManual}
\title{Create Reference Manual Markdown}
\usage{
ReferenceManual(
  pkg = getwd(),
  outdir = getwd(),
  front.matter = "",
  toc.matter = "<!-- toc -->",
  date.format = "\%B \%d, \%Y",
  verbose = FALSE
)
}
\arguments{
\item{pkg}{Full path to package directory. Default value is the working directory. 
Alternatively, a package name can be passed. If this is the case, \code{\link[base]{find.package}} is applied.}

\item{outdir}{Output directory where the reference manual markdown shall be written to.}

\item{front.matter}{String with yaml-style heading of markdown file.}

\item{toc.matter}{String providing the table of contents. This is not auto-generated.
The default value is a HTML comment, used by gitbook plugin
\href{https://www.npmjs.com/package/gitbook-plugin-toc}{toc}.}

\item{date.format}{Date format that shall be written to the beginning of the reference manual. 
If \code{NULL}, no date is written.
Otherwise, provide a valid format (e.g. \code{\%Y-\%m-\%d}), see Details in \link[base]{strptime}.}

\item{verbose}{If \code{TRUE} all messages and process steps will be printed}
}
\description{
This is a wrapper to combine the Rd files of a package source or binary 
into a reference manual in markdown format.
}
\examples{
## give source directory of your package
pkg_dir = "~/git/MyPackage"

## specify, where reference manual shall be stored
out_dir = "/var/www/html/R_Web_app/md/"

## create reference manual
## ReferenceManual(pkg = pkg_dir, outdir = out_dir)
}
\references{
Murdoch, D. (2010). \href{https://developer.R-project.org/parseRd.pdf}{Parsing Rd files}
}
\seealso{
Package \href{https://github.com/jbryer/Rd2markdown}{Rd2markdown} by jbryer
}
