% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_LPP.R
\name{do.lpp}
\alias{do.lpp}
\title{Locality Preserving Projections}
\usage{
do.lpp(X, ndim = 2, type = c("proportion", 0.1), symmetric = "union",
  weight = TRUE, preprocess = "null", t = 1)
}
\arguments{
\item{X}{an \code{(n-by-p)} matrix or data frame whose rows are observations}

\item{ndim}{an integer-valued target dimension.}

\item{type}{a vector of neighborhood graph construction. Following types are supported;
\code{c("knn",k)}, \code{c("enn",radius)}, and \code{c("proportion",ratio)}.
Default is \code{c("proportion",0.1)}, connecting about 1/10 of nearest data points
among all data points. See also \code{\link{aux.graphnbd}} for more details.}

\item{symmetric}{one of \code{"intersect"}, \code{"union"} or \code{"asymmetric"} is supported. Default is \code{"union"}.
See also \code{\link{aux.graphnbd}} for more details.}

\item{weight}{\code{TRUE} to perform LPP on weighted graph, or \code{FALSE} otherwise.}

\item{preprocess}{an additional option for preprocessing the data.}

\item{t}{bandwidth for heat kernel in \eqn{(0,\infty)}}
}
\value{
a named list containing
\describe{
\item{Y}{an \code{(n-by-ndim)} matrix whose rows are embedded observations.}
\item{eigval}{a vector of eigenvalues corresponding to basis expansion in an ascending order.}
\item{projection}{a \code{(p-by-ndim)} whose columns are basis for projection.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
}
}
\description{
\code{do.lpp} is a linear approximation to Laplacian Eigenmaps.
}
\examples{
## generate data
## in order to pass CRAN pretest, n is set to be small.
X <- aux.gensamples(dname="twinpeaks",n=28)

## 1. connecting 10\% of data for graph construction.
output1 <- do.lpp(X,ndim=2,type=c("proportion",0.10))

## 2. constructing 25\%-connected graph
output2 <- do.lpp(X,ndim=2,type=c("proportion",0.25))

## 3. constructing half-connected graph as binarized
output3 <- do.lpp(X,ndim=2,type=c("proportion",0.5),weight=FALSE)

## Visualize three different projections
if ((!is.na(output1))&&(!is.na(output2))&&(!is.na(output3))){
par(mfrow=c(1,3))
plot(output1$Y[,1],output1$Y[,2],main="5\%")
plot(output2$Y[,1],output2$Y[,2],main="25\%")
plot(output3$Y[,1],output3$Y[,2],main="50\%")
} else {
message("* do.lpp : example : one of three trials must have failed.")
}


}
\references{
\insertRef{he_locality_2005}{Rdimtools}
}
\author{
Kisung You
}
