% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_twonn.R
\name{est.twonn}
\alias{est.twonn}
\title{Intrinsic Dimension Estimation by a Minimal Neighborhood Information}
\usage{
est.twonn(X)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations.}
}
\value{
a named list containing containing \describe{
\item{estdim}{estimated intrinsic dimension.}
}
}
\description{
Unlike many intrinsic dimension (ID) estimation methods, \code{est.twonn} only requires
two nearest datapoints from a target point and their distances. This extremely minimal approach
is claimed to redue the effects of curvature and density variation across different locations
in an underlying manifold.
}
\examples{
\donttest{
## create 3 datasets of intrinsic dimension 2.
X1 = aux.gensamples(dname="swiss")
X2 = aux.gensamples(dname="ribbon")
X3 = aux.gensamples(dname="saddle")

## acquire an estimate for intrinsic dimension
out1 = est.twonn(X1)
out2 = est.twonn(X2)
out3 = est.twonn(X3)

## print the results
line1 = paste0("* est.twonn : 'swiss'  gives ",round(out1$estdim,2))
line2 = paste0("* est.twonn : 'ribbon' gives ",round(out2$estdim,2))
line3 = paste0("* est.twonn : 'saddle' gives ",round(out3$estdim,2))
cat(paste0(line1,"\n",line2,"\n",line3))
}

}
\references{
\insertRef{facco_estimating_2017}{Rdimtools}
}
\author{
Kisung You
}
