% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.dfunc.R
\name{predict.dfunc}
\alias{predict.dfunc}
\title{Predict method for dfunc objects}
\usage{
\method{predict}{dfunc}(object, newdata, type = c("parameters"), ...)
}
\arguments{
\item{object}{An estimated dfunc object.  See \code{\link{dfuncEstim}}.}

\item{newdata}{A data frame containing new values of 
the covariates at which predictions are to be computed.}

\item{type}{The type of predictions desired. Currently, only 
type = "parameters" is implemented and returns 
parameters of the likelihood function.}

\item{\dots}{Included for compatibility with generic \code{predict} methods.}
}
\value{
A matrix of predicted parameter for the distance function
estimated in \code{dfunc}. Extent of the first dimension (rows) in 
the returned matrix is equal to either the number of detection distances 
in \code{detectionData} or number of rows in \code{newdata}. 
The returned matrix's second dimension (columns) is 
the number of canonical parameters in the likelihood 
plus the number of expansion terms.  Without expansion terms, the number 
of columns in the returned matrix 
is either 1 or 2 depending on the likelihood (e.g., \code{halfnorm} has 
one parameter, \code{hazrate} has two).
}
\description{
Predict likelihood parameters or inflation 
factors for distance function objects
}
\author{
Trent McDonald, WEST Inc.,  \email{tmcdonald@west-inc.com}
}
