/*
 * Decompiled with CFR 0.152.
 */
package org.drools.io.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import org.drools.ChangeSet;
import org.drools.SystemEventListener;
import org.drools.SystemEventListenerFactory;
import org.drools.event.io.ResourceChangeListener;
import org.drools.io.Resource;
import org.drools.io.ResourceChangeMonitor;
import org.drools.io.ResourceChangeNotifier;
import org.drools.io.impl.ChangeSetImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceChangeNotifierImpl
implements ResourceChangeNotifier {
    private Map<Resource, Set<ResourceChangeListener>> subscriptions;
    private List<ResourceChangeMonitor> monitors;
    private SystemEventListener listener = SystemEventListenerFactory.getSystemEventListener();
    private LinkedBlockingQueue<ChangeSet> queue;
    private Thread thread;
    private ProcessChangeSet processChangeSet;

    public ResourceChangeNotifierImpl() {
        this.subscriptions = new HashMap<Resource, Set<ResourceChangeListener>>();
        this.monitors = new CopyOnWriteArrayList<ResourceChangeMonitor>();
        this.queue = new LinkedBlockingQueue();
        this.listener.info("ResourceChangeNotification created");
    }

    public void setSystemEventListener(SystemEventListener listener) {
        this.listener = listener;
    }

    public void addResourceChangeMonitor(ResourceChangeMonitor monitor) {
        if (!this.monitors.contains(monitor)) {
            this.listener.debug("ResourceChangeNotification monitor added monitor=" + monitor);
            this.monitors.add(monitor);
        }
    }

    public void removeResourceChangeMonitor(ResourceChangeMonitor monitor) {
        this.listener.debug("ResourceChangeNotification monitor removed monitor=" + monitor);
        this.monitors.remove(monitor);
    }

    public Collection<ResourceChangeMonitor> getResourceChangeMonitors() {
        return Collections.unmodifiableCollection(this.monitors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribeResourceChangeListener(ResourceChangeListener listener, Resource resource) {
        this.listener.debug("ResourceChangeNotification subscribing listener=" + listener + " to resource=" + resource);
        Map<Resource, Set<ResourceChangeListener>> map = this.subscriptions;
        synchronized (map) {
            Set<ResourceChangeListener> listeners = this.subscriptions.get(resource);
            if (listeners == null) {
                listeners = new HashSet<ResourceChangeListener>();
                this.subscriptions.put(resource, listeners);
                for (ResourceChangeMonitor monitor : this.monitors) {
                    monitor.subscribeNotifier((ResourceChangeNotifier)this, resource);
                }
            }
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeResourceChangeListener(ResourceChangeListener listener, Resource resource) {
        this.listener.debug("ResourceChangeNotification unsubscribing listener=" + listener + " to resource=" + resource);
        Map<Resource, Set<ResourceChangeListener>> map = this.subscriptions;
        synchronized (map) {
            Set<ResourceChangeListener> listeners = this.subscriptions.get(resource);
            if (listeners == null) {
                return;
            }
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this.subscriptions.remove(resource);
                for (ResourceChangeMonitor monitor : this.monitors) {
                    monitor.unsubscribeNotifier((ResourceChangeNotifier)this, resource);
                }
            }
        }
    }

    public void subscribeChildResource(Resource directory, Resource child) {
        this.listener.debug("ResourceChangeNotification subscribing directory=" + directory + " content resource=" + child);
        for (ResourceChangeListener listener : this.subscriptions.get(directory)) {
            this.subscribeResourceChangeListener(listener, child);
        }
    }

    public void publishChangeSet(ChangeSet changeSet) {
        try {
            this.listener.debug("ResourceChangeNotification received ChangeSet notification");
            this.queue.put(changeSet);
        }
        catch (InterruptedException e) {
            this.listener.exception((Throwable)new RuntimeException("ResourceChangeNotification Exception while adding to notification queue", e));
        }
    }

    public void processChangeSet(ChangeSet changeSet) {
        ChangeSetImpl localChangeSet;
        Set<ResourceChangeListener> listeners;
        HashMap<ResourceChangeListener, ChangeSetImpl> localChangeSets = new HashMap<ResourceChangeListener, ChangeSetImpl>();
        this.listener.debug("ResourceChangeNotification processing ChangeSet");
        for (Resource resource : changeSet.getResourcesAdded()) {
            listeners = this.subscriptions.get(resource);
            for (ResourceChangeListener listener : listeners) {
                localChangeSet = (ChangeSetImpl)localChangeSets.get(listener);
                if (localChangeSet == null) {
                    localChangeSet = new ChangeSetImpl();
                    localChangeSets.put(listener, localChangeSet);
                }
                if (localChangeSet.getResourcesAdded().isEmpty()) {
                    localChangeSet.setResourcesAdded(new ArrayList<Resource>());
                }
                localChangeSet.getResourcesAdded().add(resource);
                this.listener.debug("ResourceChangeNotification ChangeSet added resource=" + resource + " for listener=" + listener);
            }
        }
        for (Resource resource : changeSet.getResourcesRemoved()) {
            listeners = this.subscriptions.remove(resource);
            for (ResourceChangeListener listener : listeners) {
                localChangeSet = (ChangeSetImpl)localChangeSets.get(listener);
                if (localChangeSet == null) {
                    localChangeSet = new ChangeSetImpl();
                    localChangeSets.put(listener, localChangeSet);
                }
                if (localChangeSet.getResourcesRemoved().isEmpty()) {
                    localChangeSet.setResourcesRemoved(new ArrayList<Resource>());
                }
                localChangeSet.getResourcesRemoved().add(resource);
                this.listener.debug("ResourceChangeNotification ChangeSet removed resource=" + resource + " for listener=" + listener);
            }
        }
        for (Resource resource : changeSet.getResourcesModified()) {
            listeners = this.subscriptions.get(resource);
            for (ResourceChangeListener listener : listeners) {
                localChangeSet = (ChangeSetImpl)localChangeSets.get(listener);
                if (localChangeSet == null) {
                    localChangeSet = new ChangeSetImpl();
                    localChangeSets.put(listener, localChangeSet);
                }
                if (localChangeSet.getResourcesModified().isEmpty()) {
                    localChangeSet.setResourcesModified(new ArrayList<Resource>());
                }
                localChangeSet.getResourcesModified().add(resource);
                this.listener.debug("ResourceChangeNotification ChangeSet modified resource=" + resource + " for listener=" + listener);
            }
        }
        for (Map.Entry entry : localChangeSets.entrySet()) {
            ResourceChangeListener listener = (ResourceChangeListener)entry.getKey();
            ChangeSetImpl localChangeSet2 = (ChangeSetImpl)entry.getValue();
            listener.resourcesChanged((ChangeSet)localChangeSet2);
        }
    }

    public void start() {
        this.processChangeSet = new ProcessChangeSet(this.queue, this, this.listener);
        this.thread = new Thread(this.processChangeSet);
        this.thread.start();
    }

    public void stop() {
        this.processChangeSet.stop();
        this.thread.interrupt();
        this.processChangeSet = null;
    }

    public void reset() {
        this.subscriptions.clear();
        this.monitors.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProcessChangeSet
    implements Runnable {
        private volatile boolean notify;
        private LinkedBlockingQueue<ChangeSet> queue;
        private ResourceChangeNotifierImpl notifier;
        private SystemEventListener listener;

        ProcessChangeSet(LinkedBlockingQueue<ChangeSet> queue, ResourceChangeNotifierImpl notifier, SystemEventListener listener) {
            this.queue = queue;
            this.notifier = notifier;
            this.listener = listener;
            this.notify = true;
        }

        public void stop() {
            this.notify = false;
        }

        public boolean isRunning() {
            return this.notify;
        }

        @Override
        public void run() {
            if (this.notify) {
                this.listener.info("ResourceChangeNotification has started listening for ChangeSet publications");
            }
            while (this.notify) {
                InterruptedException exception = null;
                try {
                    this.listener.debug("ResourceChangeNotification thread is waiting for queue update");
                    this.notifier.processChangeSet(this.queue.take());
                }
                catch (InterruptedException e) {
                    exception = e;
                }
                Thread.yield();
                if (!this.notify || exception == null) continue;
                this.listener.exception((Throwable)new RuntimeException("ResourceChangeNotification ChangeSet publication thread was interrupted, but shutdown was not scheduled", exception));
            }
            this.listener.info("ResourceChangeNotification has stopped listening for ChangeSet publications");
        }
    }
}

