/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.integration.impl;

import java.util.Map;
import org.mvel2.DataConversion;
import org.mvel2.integration.VariableResolver;

public class PrecachedMapVariableResolver
implements VariableResolver {
    private String name;
    private Class<?> knownType;
    private Map.Entry entry;

    public PrecachedMapVariableResolver(Map.Entry entry, String name) {
        this.entry = entry;
        this.name = name;
    }

    public PrecachedMapVariableResolver(Map.Entry entry, String name, Class knownType) {
        this.name = name;
        this.knownType = knownType;
        this.entry = entry;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStaticType(Class knownType) {
        this.knownType = knownType;
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        return this.knownType;
    }

    public void setValue(Object value) {
        if (this.knownType != null && value != null && value.getClass() != this.knownType) {
            Class<?> t = value.getClass();
            if (!DataConversion.canConvert(this.knownType, t)) {
                throw new RuntimeException("cannot assign " + value.getClass().getName() + " to type: " + this.knownType.getName());
            }
            try {
                value = DataConversion.convert(value, this.knownType);
            }
            catch (Exception e) {
                throw new RuntimeException("cannot convert value of " + value.getClass().getName() + " to: " + this.knownType.getName());
            }
        }
        this.entry.setValue(value);
    }

    public Object getValue() {
        return this.entry.getValue();
    }

    public int getFlags() {
        return 0;
    }
}

