/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.rule;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import org.drools.core.base.ValueType;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.rule.Pattern;
import org.drools.core.spi.AcceptsReadAccessor;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.util.ClassUtils;

public class Declaration
implements Externalizable,
AcceptsReadAccessor,
Cloneable {
    private static final long serialVersionUID = 510L;
    private String identifier;
    private String bindingName;
    private InternalReadAccessor readAccessor;
    private Pattern pattern;
    private boolean internalFact;
    private transient Class<?> declarationClass;
    private transient String cachedTypeName;
    private transient String cachedBoxedTypeName;

    public Declaration() {
        this(null, null, null);
    }

    public Declaration(String identifier, Pattern pattern) {
        this(identifier, null, pattern, false);
    }

    public Declaration(String identifier, InternalReadAccessor extractor, Pattern pattern) {
        this(identifier, extractor, pattern, false);
    }

    public Declaration(String identifier, InternalReadAccessor extractor, Pattern pattern, boolean internalFact) {
        this.identifier = identifier;
        this.readAccessor = extractor;
        this.pattern = pattern;
        this.internalFact = internalFact;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.identifier = (String)in.readObject();
        this.readAccessor = (InternalReadAccessor)in.readObject();
        this.pattern = (Pattern)in.readObject();
        this.internalFact = in.readBoolean();
        this.bindingName = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.identifier);
        out.writeObject(this.readAccessor);
        out.writeObject(this.pattern);
        out.writeBoolean(this.internalFact);
        out.writeObject(this.bindingName);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getBindingName() {
        return this.bindingName != null ? this.bindingName : this.identifier;
    }

    public void setBindingName(String bindingName) {
        this.bindingName = bindingName;
    }

    public ValueType getValueType() {
        return this.readAccessor.getValueType();
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public boolean isPatternDeclaration() {
        return this.pattern != null && this.pattern.getDeclaration() == this || this.getIdentifier().equals("this");
    }

    @Override
    public void setReadAccessor(InternalReadAccessor readAccessor) {
        this.readAccessor = readAccessor;
    }

    public InternalReadAccessor getExtractor() {
        return this.readAccessor;
    }

    public Class<?> getDeclarationClass() {
        if (this.declarationClass == null) {
            this.declarationClass = this.readAccessor != null ? this.readAccessor.getExtractToClass() : null;
        }
        return this.declarationClass;
    }

    public void setDeclarationClass(Class<?> declarationClass) {
        this.declarationClass = declarationClass;
    }

    public Object getValue(InternalWorkingMemory workingMemory, Object object) {
        return this.readAccessor.getValue(workingMemory, object);
    }

    public char getCharValue(InternalWorkingMemory workingMemory, Object object) {
        return this.readAccessor.getCharValue(workingMemory, object);
    }

    public int getIntValue(InternalWorkingMemory workingMemory, Object object) {
        return this.readAccessor.getIntValue(workingMemory, object);
    }

    public byte getByteValue(InternalWorkingMemory workingMemory, Object object) {
        return this.readAccessor.getByteValue(workingMemory, object);
    }

    public short getShortValue(InternalWorkingMemory workingMemory, Object object) {
        return this.readAccessor.getShortValue(workingMemory, object);
    }

    public long getLongValue(InternalWorkingMemory workingMemory, Object object) {
        return this.readAccessor.getLongValue(workingMemory, object);
    }

    public float getFloatValue(InternalWorkingMemory workingMemory, Object object) {
        return this.readAccessor.getFloatValue(workingMemory, object);
    }

    public double getDoubleValue(InternalWorkingMemory workingMemory, Object object) {
        return this.readAccessor.getDoubleValue(workingMemory, object);
    }

    public boolean getBooleanValue(InternalWorkingMemory workingMemory, Object object) {
        return this.readAccessor.getBooleanValue(workingMemory, object);
    }

    public int getHashCode(InternalWorkingMemory workingMemory, Object object) {
        return this.readAccessor.getHashCode(workingMemory, object);
    }

    public boolean isGlobal() {
        return this.readAccessor != null && this.readAccessor.isGlobal();
    }

    public Method getNativeReadMethod() {
        if (this.readAccessor != null) {
            return this.readAccessor.getNativeReadMethod();
        }
        try {
            return this.getClass().getDeclaredMethod("getValue", InternalWorkingMemory.class, Object.class);
        }
        catch (Exception e) {
            throw new RuntimeException("This is a bug. Please report to development team: " + e.getMessage(), e);
        }
    }

    public String getNativeReadMethodName() {
        return this.readAccessor != null ? this.readAccessor.getNativeReadMethodName() : "getValue";
    }

    public String getTypeName() {
        if (this.cachedTypeName == null) {
            this.cachedTypeName = this.getExtractor() != null && this.getDeclarationClass() != null ? ClassUtils.canonicalName(this.getDeclarationClass()) : "java.lang.Object";
        }
        return this.cachedTypeName;
    }

    public String getBoxedTypeName() {
        if (this.cachedBoxedTypeName == null) {
            this.cachedBoxedTypeName = this.getExtractor() != null ? ClassUtils.canonicalName(ClassUtils.convertFromPrimitiveType(this.getDeclarationClass())) : "java.lang.Object";
        }
        return this.cachedBoxedTypeName;
    }

    public String toString() {
        return "(" + this.readAccessor.getValueType() + ") " + this.identifier;
    }

    public int hashCode() {
        int result = 29 * this.pattern.getOffset();
        result += 31 * this.readAccessor.hashCode();
        return result += 37 * this.identifier.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Declaration other = (Declaration)object;
        return this.pattern.getOffset() == other.pattern.getOffset() && this.identifier.equals(other.identifier) && this.readAccessor.equals(other.readAccessor);
    }

    public boolean isInternalFact() {
        return this.internalFact;
    }

    public Declaration clone() {
        return new Declaration(this.identifier, this.readAccessor, this.pattern);
    }
}

