% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/relist.R, R/unlist.R
\name{RelistBibEntry}
\alias{RelistBibEntry}
\alias{unlist.BibEntry}
\title{Flatten and unflatten BibEntry objects}
\usage{
RelistBibEntry(flesh, skeleton = NULL)

\method{unlist}{BibEntry}(x, recursive = FALSE, use.names = TRUE)
}
\arguments{
\item{flesh}{list; an \code{unlist}ed BibEntry object}

\item{skeleton}{currently ignored}

\item{x}{a BibEntry object to flatten}

\item{recursive}{ignored.}

\item{use.names}{ignored.}
}
\value{
\code{RelistBibEntry} - an object of class BibEntry

For \code{unlist}, a list with bib entries collapsed into a single list.
}
\description{
\code{RelistBibEntry} unflattens a BibEntry object that has been flattened with \code{unlist}.

\code{unlist} flattens a BibEntry object to a single list where every field (including \code{bibtype} and \code{key})
of every entry is a separate element in the list.
}
\details{
\code{RelistBibEntry} is only intended for use with \code{unlist}ed BibEntry objects.
}
\note{
The names of the list elements from an unlisted BibEntry object will not be unique.  To do this see \code{\link{make.unique}}.
}
\examples{
bib <- list(c(bibtype = "article", key = "mclean2014a", title = "My New Article",
  author = "Mathew W. McLean", journaltitle = "The Journal", date = "2014-01"),
  c(bibtype = "article", key = "mclean2014b", title = "My Newer Article",
  author = "Mathew W. McLean", journaltitle = "The Journal", date = "2014-02"))
bib <- as.BibEntry(bib)
unlist(bib)
RelistBibEntry(unlist(bib))
}
\seealso{
\code{\link{as.BibEntry}}
}
\keyword{database}
\keyword{list}
\keyword{manip}

