% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cdiff.R
\name{Cdiff}
\alias{Cdiff}
\title{Matrix difference (a-b) including checking for equal columns}
\usage{
Cdiff(a, b, tolerance = sqrt(.Machine$double.eps))
}
\arguments{
\item{a}{numerical matrix}

\item{b}{numerical matrix}

\item{tolerance}{parameter to \code{\link{all.equal}}}
}
\value{
(a-b) where equal columns are set to zero
}
\description{
Each column is checked by \code{\link{all.equal}}
}
\examples{
a <- matrix(rnorm(6), 3, 2)
b <- matrix(rnorm(6), 3, 2)
a - b
Cdiff(a, b)
b[, 1] <- a[, 1] + (.Machine$double.eps)^(2/3) * b[, 1]
a - b
Cdiff(a, b)
a[, 2] <- b[, 2]
a - b
Cdiff(a, b)
}
\keyword{internal}
