\name{senv}
\alias{senv}
\title{Fit the scaled response envelope model}
\description{
 Fit the scaled response envelope model in multivariate linear regression with dimension u. The scaled response envelope model is a scale-invariant version of the response envelope model.  
}
\usage{
senv(X, Y, u, asy = TRUE, init = NULL)
}
\arguments{
  \item{X}{Predictors. An n by p matrix, p is the number of predictors. The predictors can be univariate or multivariate, discrete or continuous.}
  \item{Y}{Multivariate responses. An n by r matrix, r is the number of responses and n is number of observations. The responses must be continuous variables.}
  \item{u}{Dimension of the scaled envelope. An integer between 0 and r.}
  \item{asy}{Flag for computing the asymptotic variance of the envelope estimator.  The default is \code{TRUE}. When p and r are large, computing the asymptotic variance can take much time and memory.  If only the scaled envelope estimators are needed, the flag can be set to \code{asy = FALSE}.}
  \item{init}{The user-specified value of Gamma for the scaled envelope subspace. An r by u matrix. The default is the one generated by function senvMU.}
}
\details{
 This function fits the scaled envelope model to the responses and predictors, \deqn{
 Y = \mu + \Lambda\Gamma\eta X + \varepsilon, \Sigma=\Lambda\Gamma\Omega\Gamma'\Lambda + \Lambda\Gamma_{0}\Omega_{0}\Gamma'_{0}\Lambda
 }
 using the maximum likelihood estimation.  When the dimension of the scaled  envelope is between 1 and r-1, the starting value and blockwise coordinate descent algorithm in Cook et al. (2016) is implemented.  When the dimension is r, then the scaled envelope model degenerates to the standard multivariate linear regression.  When the dimension is 0, it means that X and Y are uncorrelated, and the fitting is different.
}
\value{The output is a list that contains the following components:
\item{beta}{The scaled envelope estimator of the regression coefficients.} 
\item{Sigma}{The scaled envelope estimator of the error covariance matrix.}
\item{Lambda}{The matrix of estimated scale.}
\item{Gamma}{An orthonormal basis of the scaled envelope subspace.}
\item{Gamma0}{An orthonormal basis of the complement of the scaled envelope subspace.}
\item{eta}{The coordinates of beta with respect to Gamma.}
\item{Omega}{The coordinates of Sigma with respect to Gamma.}
\item{Omega0}{The coordinates of Sigma with respect to Gamma0.}
\item{mu}{The estimated intercept.}
\item{loglik}{The maximized log likelihood function.}
\item{covMatrix}{The asymptotic covariance of vec(beta). The covariance matrix returned are asymptotic.  For the actual standard errors, multiply by 1 / n.}
\item{asySE}{The asymptotic standard error for elements in beta under the envelope model.  The standard errors returned are asymptotic, for actual standard errors, multiply by 1 / sqrt(n).}
\item{ratio}{The asymptotic standard error ratio of the standard multivariate linear regression estimator over the envelope estimator, for each element in beta.}
\item{n}{The number of observations in the data.}
}
\references{
Cook, R. D., Su, Z. (2013). Scaled Envelopes: scale Invariant and Efficient Estimation in Multivariate Linear Regression. Biometrika 100, 939 - 954.

Cook, R. D., Forzani, L. and Su, Z. (2016) A Note on Fast Envelope Estimation. Journal of Multivariate Analysis. 150, 42-54.
}

\examples{
data(sales)
X <- sales[, 1:3]
Y <- sales[, 4:7]

u <- u.senv(X, Y)
u

m <- senv(X, Y, 2)
m$beta
}

