% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversionHelpers.R
\name{ci2se}
\alias{ci2se}
\alias{ci2estimate}
\alias{ci2z}
\alias{ci2p}
\alias{z2p}
\alias{p2z}
\title{Convert between estimates, z-values, p-values, and confidence intervals}
\usage{
ci2se(lower, upper, conf.level = 0.95, ratio = FALSE)

ci2estimate(lower, upper, ratio = FALSE, antilog = FALSE)

ci2z(lower, upper, conf.level = 0.95, ratio = FALSE)

ci2p(
  lower,
  upper,
  conf.level = 0.95,
  ratio = FALSE,
  alternative = c("two.sided", "one.sided", "less", "greater")
)

z2p(z, alternative = c("two.sided", "one.sided", "less", "greater"))

p2z(p, alternative = c("two.sided", "one.sided", "less", "greater"))
}
\arguments{
\item{lower}{Numeric vector of lower confidence interval bounds.}

\item{upper}{Numeric vector of upper confidence interval bounds.}

\item{conf.level}{The confidence level of the confidence intervals. Default is 0.95.}

\item{ratio}{Indicates whether the confidence interval is for a ratio, e.g. an
odds ratio, relative risk or hazard ratio. If \code{TRUE}, the standard error
of the log ratio is computed. Defaults to \code{FALSE}.}

\item{antilog}{Indicates whether the estimate is reported on the ratio scale.
Only applies if \code{ratio = TRUE}. Defaults to \code{FALSE}.}

\item{alternative}{Direction of the alternative of the p-value. 
Either "two.sided" (default), "one.sided", "less", or "greater".
If "one.sided" or "two.sided" is specified, the z-value is assumed to be positive.}

\item{z}{Numeric vector of z-values.}

\item{p}{Numeric vector of p-values.}
}
\value{
\code{ci2se} returns a numeric vector of standard errors.

\code{ci2estimate} returns a numeric vector of parameter estimates.

\code{ci2z} returns a numeric vector of z-values.

\code{ci2p} returns a numeric vector of p-values.

\code{z2p} returns a numeric vector of p-values.

\code{p2z} returns a numeric vector of z-values.
}
\description{
Convert between estimates, z-values, p-values, and confidence intervals
}
\details{
\code{z2p} is the vectorized version of \code{.z2p_}.
\code{\link[base]{Vectorize}} is used to vectorize the function.

\code{p2z} is the vectorized version of \code{.p2z_}.
\code{\link[base]{Vectorize}} is used to vectorize the function.
}
\examples{
ci2se(lower = 1, upper = 3)
ci2se(lower = 1, upper = 3, ratio = TRUE)
ci2se(lower = 1, upper = 3, conf.level = 0.9)

ci2estimate(lower = 1, upper = 3)
ci2estimate(lower = 1, upper = 3, ratio = TRUE)
ci2estimate(lower = 1, upper = 3, ratio = TRUE, antilog = TRUE)

ci2z(lower = 1, upper = 3)
ci2z(lower = 1, upper = 3, ratio = TRUE)
ci2z(lower = 1, upper = 3, conf.level = 0.9)

ci2p(lower = 1, upper = 3)
ci2p(lower = 1, upper = 3, alternative = "one.sided")

z2p(z = c(1, 2, 5))
z2p(z = c(1, 2, 5), alternative = "less")
z2p(z = c(1, 2, 5), alternative = "greater")
z <- seq(-3, 3, by = 0.01)
plot(z, z2p(z), type = "l", xlab = "z", ylab = "p", ylim = c(0, 1))
lines(z, z2p(z, alternative = "greater"), lty = 2)
legend("topright", c("two-sided", "greater"), lty = c(1, 2), bty = "n")

p2z(p = c(0.005, 0.01, 0.05))
p2z(p = c(0.005, 0.01, 0.05), alternative = "greater")
p2z(p = c(0.005, 0.01, 0.05), alternative = "less")
p <- seq(0.001, 0.05, 0.0001)
plot(p, p2z(p), type = "l", ylim = c(0, 3.5), ylab = "z")
lines(p, p2z(p, alternative = "greater"), lty = 2)
legend("bottomleft", c("two-sided", "greater"), lty = c(1, 2), bty = "n")
}
