/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.docx4r.elements;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import javax.xml.bind.JAXBElement;
import org.docx4j.dml.CTPositiveSize2D;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage;
import org.docx4j.wml.CTBookmark;
import org.docx4j.wml.CTMarkupRange;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.R;

public class Image {
    private byte[] image_bytes;
    private boolean hasBookmark;
    private JAXBElement<CTBookmark> bmStart;
    private JAXBElement<CTMarkupRange> bmEnd;

    public Image(String filename) {
        File file = new File(filename);
        try {
            this.image_bytes = Image.convertImageToByteArray(file);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.hasBookmark = false;
    }

    public void setBookmark(String bookmark, BigInteger bookmarkID) {
        this.hasBookmark = true;
        ObjectFactory factory = Context.getWmlObjectFactory();
        CTBookmark bm = new CTBookmark();
        bm.setId(bookmarkID);
        bm.setName(bookmark);
        this.bmStart = factory.createBodyBookmarkStart(bm);
        CTMarkupRange mr = factory.createCTMarkupRange();
        mr.setId(bookmarkID);
        this.bmEnd = factory.createBodyBookmarkEnd(mr);
    }

    public P addImageToPackage(WordprocessingMLPackage wordMLPackage, int docPrId, int cNvPrId, int width, int height, PPr ppr) throws Exception {
        BinaryPartAbstractImage imagePart = BinaryPartAbstractImage.createImagePart((WordprocessingMLPackage)wordMLPackage, (byte[])this.image_bytes);
        Inline inline = imagePart.createImageInline("Filename hint", "Alternative text", docPrId, cNvPrId, false);
        CTPositiveSize2D size = new CTPositiveSize2D();
        size.setCx((long)width);
        size.setCy((long)height);
        inline.setExtent(size);
        return this.addInlineImageToParagraph(inline, ppr);
    }

    public static byte[] convertImageToByteArray(File file) throws FileNotFoundException, IOException {
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            System.out.println("File too large!!");
        }
        byte[] bytes = new byte[(int)length];
        int offset = 0;
        int numRead = 0;
        while (offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0) {
            offset += numRead;
        }
        if (offset < bytes.length) {
            System.out.println("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    private P addInlineImageToParagraph(Inline inline, PPr ppr) {
        ObjectFactory factory = new ObjectFactory();
        P paragraph = factory.createP();
        paragraph.setPPr(ppr);
        if (this.hasBookmark) {
            paragraph.getContent().add(this.bmStart);
        }
        R run = factory.createR();
        paragraph.getContent().add(run);
        Drawing drawing = factory.createDrawing();
        run.getContent().add(drawing);
        drawing.getAnchorOrInline().add(inline);
        if (this.hasBookmark) {
            paragraph.getContent().add(this.bmEnd);
        }
        return paragraph;
    }

    public static Drawing addInlineImageToDrawing(String filename, WordprocessingMLPackage wordMLPackage, int docPrId, int cNvPrId) throws Exception {
        File file = new File(filename);
        byte[] bytes = Image.convertImageToByteArray(file);
        BinaryPartAbstractImage imagePart = BinaryPartAbstractImage.createImagePart((WordprocessingMLPackage)wordMLPackage, (byte[])bytes);
        Inline inline = imagePart.createImageInline("Filename hint", "Alternative text", docPrId, cNvPrId, false);
        ObjectFactory factory = new ObjectFactory();
        Drawing drawing = factory.createDrawing();
        drawing.getAnchorOrInline().add(inline);
        return drawing;
    }
}

