/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.tables;

import java.io.IOException;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.docx4j.dml.CTGraphicalObjectFrameLocking;
import org.docx4j.dml.CTNonVisualDrawingProps;
import org.docx4j.dml.CTNonVisualGraphicFrameProperties;
import org.docx4j.dml.CTTable;
import org.docx4j.dml.CTTableCol;
import org.docx4j.dml.CTTableGrid;
import org.docx4j.dml.CTTableProperties;
import org.docx4j.dml.CTTableRow;
import org.docx4j.dml.CTTransform2D;
import org.docx4j.dml.Graphic;
import org.docx4j.dml.GraphicData;
import org.docx4j.jaxb.Context;
import org.docx4j.wml.CTTblLayoutType;
import org.docx4j.wml.Jc;
import org.docx4j.wml.JcEnumeration;
import org.docx4j.wml.STTblLayoutType;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.TblGrid;
import org.docx4j.wml.TblGridCol;
import org.docx4j.wml.TblPr;
import org.docx4j.wml.Tr;
import org.docx4j.wml.TrPr;
import org.lysis.reporters.html4r.elements.HTML4R;
import org.lysis.reporters.tables.BorderProperties;
import org.lysis.reporters.tables.CellProperties;
import org.lysis.reporters.tables.FlexCell;
import org.lysis.reporters.tables.FlexRow;
import org.lysis.reporters.texts.ParProperties;
import org.lysis.reporters.texts.Paragraph;
import org.lysis.reporters.texts.ParagraphsSection;
import org.lysis.reporters.texts.TextProperties;
import org.pptx4j.pml.CTGraphicalObjectFrame;
import org.pptx4j.pml.CTGraphicalObjectFrameNonVisual;
import org.pptx4j.pml.ObjectFactory;

public class FlexTable
implements HTML4R {
    private LinkedHashMap<Integer, FlexRow> headerRowList;
    private int headerLines;
    private LinkedHashMap<Integer, FlexRow> footerRowList;
    private int footerLines;
    private int nrow;
    private int ncol;
    private ParagraphsSection[][] cellTextValue;
    private CellProperties[][] cellPropertiesIndex;
    protected LinkedHashMap<Integer, int[]> rowSpanInstructions;
    protected LinkedHashMap<Integer, int[]> colSpanInstructions;
    protected double[] widths;

    public FlexTable(int n, int c, TextProperties tp, ParProperties pp, CellProperties cp) {
        this.cellTextValue = new ParagraphsSection[n][c];
        this.widths = new double[c];
        int j = 0;
        while (j < c) {
            this.widths[j] = -1.0;
            ++j;
        }
        this.cellPropertiesIndex = new CellProperties[n][c];
        int i = 0;
        while (i < n) {
            int j2 = 0;
            while (j2 < c) {
                Paragraph par = new Paragraph();
                try {
                    par.addText("", tp);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.cellTextValue[i][j2] = new ParagraphsSection(pp);
                this.cellTextValue[i][j2].addParagraph(par);
                this.cellPropertiesIndex[i][j2] = cp.getClone();
                ++j2;
            }
            ++i;
        }
        this.headerLines = 0;
        this.headerRowList = new LinkedHashMap();
        this.footerLines = 0;
        this.footerRowList = new LinkedHashMap();
        this.nrow = n;
        this.ncol = c;
        this.rowSpanInstructions = new LinkedHashMap();
        this.colSpanInstructions = new LinkedHashMap();
    }

    public void setWidths(double[] w) {
        this.widths = w;
    }

    public void setRowSpanInstructions(int colindex, int[] x) {
        this.rowSpanInstructions.put(colindex, x);
    }

    public void setColSpanInstructions(int rowindex, int[] x) {
        this.colSpanInstructions.put(rowindex, x);
    }

    public void addHeader(FlexRow fr) {
        this.headerRowList.put(this.headerLines, fr);
        ++this.headerLines;
    }

    public void addFooter(FlexRow fr) {
        this.footerRowList.put(this.footerLines, fr);
        ++this.footerLines;
    }

    public void resetHeader() {
        this.headerRowList.clear();
        this.headerLines = 0;
    }

    public void addBodyText(int[] i, int[] j, String[] par, TextProperties tp, boolean newPar) throws IOException {
        int li = i.length;
        int lj = j.length;
        int row = 0;
        while (row < li) {
            int col = 0;
            while (col < lj) {
                Paragraph p;
                ParagraphsSection value = this.cellTextValue[i[row]][j[col]];
                if (newPar) {
                    p = new Paragraph();
                    p.addText(par[row * lj + col], tp);
                    value.addParagraph(p);
                } else {
                    p = value.getLast();
                    p.addText(par[row * lj + col], tp);
                }
                ++col;
            }
            ++row;
        }
    }

    public void setRowsColors(int[] i, String[] colors) {
        int li = i.length;
        int row = 0;
        while (row < li) {
            int col = 0;
            while (col < this.ncol) {
                this.cellPropertiesIndex[i[row]][col].setBackgroundColor(colors[row]);
                ++col;
            }
            ++row;
        }
    }

    public void setColumnsColors(int[] j, String[] colors) {
        int lj = j.length;
        int col = 0;
        while (col < lj) {
            int row = 0;
            while (row < this.nrow) {
                this.cellPropertiesIndex[row][j[col]].setBackgroundColor(colors[col]);
                ++row;
            }
            ++col;
        }
    }

    public void setOddEvenColor(String odd_color, String even_color) {
        int col;
        int row = 0;
        while (row < this.nrow) {
            col = 0;
            while (col < this.ncol) {
                this.cellPropertiesIndex[row][col].setBackgroundColor(odd_color);
                ++col;
            }
            row += 2;
        }
        row = 1;
        while (row < this.nrow) {
            col = 0;
            while (col < this.ncol) {
                this.cellPropertiesIndex[row][col].setBackgroundColor(even_color);
                ++col;
            }
            row += 2;
        }
    }

    public void setBodyBorders(BorderProperties inner_v, BorderProperties inner_h, BorderProperties outer_v, BorderProperties outer_h) {
        int row = 0;
        while (row < this.nrow) {
            int col = 0;
            while (col < this.ncol) {
                this.cellPropertiesIndex[row][col].setBorderLeft(inner_v);
                this.cellPropertiesIndex[row][col].setBorderRight(inner_v);
                this.cellPropertiesIndex[row][col].setBorderTop(inner_h);
                this.cellPropertiesIndex[row][col].setBorderBottom(inner_h);
                ++col;
            }
            ++row;
        }
        int col = 0;
        while (col < this.ncol) {
            this.cellPropertiesIndex[0][col].setBorderTop(outer_h);
            this.cellPropertiesIndex[this.nrow - 1][col].setBorderBottom(outer_h);
            ++col;
        }
        row = 0;
        while (row < this.nrow) {
            this.cellPropertiesIndex[row][0].setBorderLeft(outer_v);
            this.cellPropertiesIndex[row][this.ncol - 1].setBorderRight(outer_v);
            ++row;
        }
    }

    public void setHeaderBorders(BorderProperties inner_v, BorderProperties inner_h, BorderProperties outer_v, BorderProperties outer_h) {
        if (this.headerLines < 1) {
            return;
        }
        int i = 0;
        while (i < this.headerLines) {
            FlexRow workingRow = this.headerRowList.get(i);
            int ncol = workingRow.size();
            if (ncol > 0) {
                int j = 1;
                while (j <= ncol) {
                    FlexCell fc = workingRow.getCell(j);
                    if (i == 0) {
                        fc.setBorderTop(outer_h);
                    } else {
                        fc.setBorderTop(inner_h);
                    }
                    if (i == this.headerLines - 1) {
                        fc.setBorderBottom(outer_h);
                    } else {
                        fc.setBorderBottom(inner_h);
                    }
                    if (j == 1) {
                        fc.setBorderLeft(outer_v);
                    } else {
                        fc.setBorderLeft(inner_v);
                    }
                    if (j == ncol) {
                        fc.setBorderRight(outer_v);
                    } else {
                        fc.setBorderRight(inner_v);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public void setFooterBorders(BorderProperties inner_v, BorderProperties inner_h, BorderProperties outer_v, BorderProperties outer_h) {
        if (this.footerLines < 1) {
            return;
        }
        int i = 0;
        while (i < this.footerLines) {
            FlexRow workingRow = this.footerRowList.get(i);
            int ncol = workingRow.size();
            if (ncol > 0) {
                int j = 1;
                while (j <= ncol) {
                    FlexCell fc = workingRow.getCell(j);
                    if (i == 0) {
                        fc.setBorderTop(outer_h);
                    } else {
                        fc.setBorderTop(inner_h);
                    }
                    if (i == this.footerLines - 1) {
                        fc.setBorderBottom(outer_h);
                    } else {
                        fc.setBorderBottom(inner_h);
                    }
                    if (j == 1) {
                        fc.setBorderLeft(outer_v);
                    } else {
                        fc.setBorderLeft(inner_v);
                    }
                    if (j == ncol) {
                        fc.setBorderRight(outer_v);
                    } else {
                        fc.setBorderRight(inner_v);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public void setCellProperties(int[] i, int[] j, CellProperties cp) {
        int li = i.length;
        int lj = j.length;
        int row = 0;
        while (row < li) {
            int col = 0;
            while (col < lj) {
                this.cellPropertiesIndex[i[row]][j[col]] = cp;
                ++col;
            }
            ++row;
        }
    }

    public void setParProperties(int[] i, int[] j, ParProperties pp) {
        int li = i.length;
        int lj = j.length;
        int row = 0;
        while (row < li) {
            int col = 0;
            while (col < lj) {
                this.cellTextValue[i[row]][j[col]].setParProperties(pp);
                ++col;
            }
            ++row;
        }
    }

    public void setTextProperties(int[] i, int[] j, TextProperties tp) {
        int li = i.length;
        int lj = j.length;
        int row = 0;
        while (row < li) {
            int col = 0;
            while (col < lj) {
                this.cellTextValue[i[row]][j[col]].setTextProperties(tp);
                ++col;
            }
            ++row;
        }
    }

    public int headerSize() {
        return this.headerLines;
    }

    public String toString() {
        String out = "";
        int i = 0;
        while (i < this.nrow) {
            out = String.valueOf(out) + "\n";
            int j = 0;
            while (j < this.ncol) {
                out = String.valueOf(out) + "\t" + this.cellTextValue[i][j].toString();
                ++j;
            }
            ++i;
        }
        return out;
    }

    private String HeaderHTML() {
        String out = "";
        out = String.valueOf(out) + "<thead>";
        int i = 0;
        while (i < this.headerLines) {
            out = String.valueOf(out) + this.headerRowList.get(i).getHTML();
            ++i;
        }
        out = String.valueOf(out) + "</thead>";
        return out;
    }

    private String FooterHTML() {
        String out = "";
        out = String.valueOf(out) + "<tfoot>";
        int i = 0;
        while (i < this.footerLines) {
            out = String.valueOf(out) + this.footerRowList.get(i).getHTML();
            ++i;
        }
        out = String.valueOf(out) + "</tfoot>";
        return out;
    }

    private void HeaderDOCX(Tbl reviewtable) {
        if (this.headerLines > 0) {
            int i = 0;
            while (i < this.headerLines) {
                Tr workingRow = this.headerRowList.get(i).getTr();
                TrPr trpr = new TrPr();
                List cnfStyleOrDivIdOrGridBefore = trpr.getCnfStyleOrDivIdOrGridBefore();
                cnfStyleOrDivIdOrGridBefore.add(Context.getWmlObjectFactory().createCTTrPrBaseTblHeader(Context.getWmlObjectFactory().createBooleanDefaultTrue()));
                workingRow.setTrPr(trpr);
                reviewtable.getContent().add(workingRow);
                ++i;
            }
        }
    }

    private void FooterDOCX(Tbl reviewtable) {
        if (this.footerLines > 0) {
            int i = 0;
            while (i < this.footerLines) {
                Tr workingRow = this.footerRowList.get(i).getTr();
                reviewtable.getContent().add(workingRow);
                ++i;
            }
        }
    }

    private void HeaderPPTX(CTTable reviewtable) throws Exception {
        if (this.headerLines < 1) {
            return;
        }
        int i = 0;
        while (i < this.headerLines) {
            CTTableRow workingRow = this.headerRowList.get(i).getCTTableRow();
            reviewtable.getTr().add(workingRow);
            ++i;
        }
    }

    private void FooterPPTX(CTTable reviewtable) throws Exception {
        if (this.footerLines < 1) {
            return;
        }
        int i = 0;
        while (i < this.footerLines) {
            CTTableRow workingRow = this.footerRowList.get(i).getCTTableRow();
            reviewtable.getTr().add(workingRow);
            ++i;
        }
    }

    private void BodyDOCX(Tbl reviewtable) {
        int i = 0;
        while (i < this.nrow) {
            Tr workingRow = new Tr();
            int j = 0;
            while (j < this.ncol) {
                FlexCell fc = new FlexCell(this.cellTextValue[i][j], this.cellPropertiesIndex[i][j]);
                if (this.rowSpanInstructions.containsKey(j)) {
                    fc.setRowspan(this.rowSpanInstructions.get(j)[i]);
                }
                if (this.colSpanInstructions.containsKey(i)) {
                    fc.setColspan(this.colSpanInstructions.get(i)[j]);
                }
                if (!this.colSpanInstructions.containsKey(i)) {
                    workingRow.getContent().add(fc.getTc());
                } else if (this.colSpanInstructions.containsKey(i) && this.colSpanInstructions.get(i)[j] > 0) {
                    workingRow.getContent().add(fc.getTc());
                }
                ++j;
            }
            reviewtable.getContent().add(workingRow);
            ++i;
        }
    }

    private void BodyPPTX(CTTable reviewtable) throws Exception {
        int i = 0;
        while (i < this.nrow) {
            CTTableRow workingRow = new CTTableRow();
            int j = 0;
            while (j < this.ncol) {
                FlexCell fc = new FlexCell(this.cellTextValue[i][j], this.cellPropertiesIndex[i][j]);
                if (this.rowSpanInstructions.containsKey(j)) {
                    fc.setRowspan(this.rowSpanInstructions.get(j)[i]);
                }
                if (this.colSpanInstructions.containsKey(i)) {
                    fc.setColspan(this.colSpanInstructions.get(i)[j]);
                }
                workingRow.getTc().add(fc.getCTTableCell());
                ++j;
            }
            reviewtable.getTr().add(workingRow);
            ++i;
        }
    }

    private String BodyHTML() {
        String out = "";
        out = String.valueOf(out) + "<tbody>";
        int i = 0;
        while (i < this.nrow) {
            out = String.valueOf(out) + "<tr>";
            int j = 0;
            while (j < this.ncol) {
                FlexCell fc = new FlexCell(this.cellTextValue[i][j], this.cellPropertiesIndex[i][j]);
                if (this.rowSpanInstructions.containsKey(j)) {
                    fc.setRowspan(this.rowSpanInstructions.get(j)[i]);
                }
                if (this.colSpanInstructions.containsKey(i)) {
                    fc.setColspan(this.colSpanInstructions.get(i)[j]);
                }
                out = String.valueOf(out) + fc.getHTML();
                ++j;
            }
            out = String.valueOf(out) + "</tr>";
            ++i;
        }
        out = String.valueOf(out) + "</tbody>";
        return out;
    }

    private CTTableGrid getCTTableGrid(long width) {
        CTTableGrid tg = new CTTableGrid();
        int i = 0;
        while (i < this.ncol) {
            List gc = tg.getGridCol();
            CTTableCol tc = new CTTableCol();
            if (this.widths[i] < 0.0) {
                tc.setW(width);
            } else {
                tc.setW((long)(this.widths[i] * 914400.0));
            }
            gc.add(tc);
            ++i;
        }
        return tg;
    }

    private CTTblLayoutType getCTTblLayoutType() {
        CTTblLayoutType layoutType = new CTTblLayoutType();
        if (this.widths[0] > 0.0) {
            layoutType.setType(STTblLayoutType.FIXED);
        } else {
            layoutType.setType(STTblLayoutType.AUTOFIT);
        }
        return layoutType;
    }

    private TblGrid getTblGrid() {
        TblGrid tblGrid = new TblGrid();
        if (this.widths[0] > 0.0) {
            int i = 0;
            while (i < this.ncol) {
                TblGridCol gridCol = Context.getWmlObjectFactory().createTblGridCol();
                gridCol.setW(BigInteger.valueOf((long)(this.widths[i] * 1440.0)));
                tblGrid.getGridCol().add(gridCol);
                ++i;
            }
        }
        return tblGrid;
    }

    public CTTable getPptxTbl(long width) throws Exception {
        CTTable newTable = new CTTable();
        CTTableProperties tablpro = new CTTableProperties();
        newTable.setTblPr(tablpro);
        newTable.setTblGrid(this.getCTTableGrid(width));
        if (this.nrow > 0) {
            this.HeaderPPTX(newTable);
            this.BodyPPTX(newTable);
            this.FooterPPTX(newTable);
        }
        return newTable;
    }

    public CTGraphicalObjectFrame getShape(long idx, long shape_id, long width) throws Exception {
        org.docx4j.dml.ObjectFactory dmlFactory = new org.docx4j.dml.ObjectFactory();
        ObjectFactory pmlFactory = new ObjectFactory();
        CTGraphicalObjectFrame graphicFrame = pmlFactory.createCTGraphicalObjectFrame();
        CTGraphicalObjectFrameNonVisual nvGraphicFramePr = pmlFactory.createCTGraphicalObjectFrameNonVisual();
        CTNonVisualDrawingProps cNvPr = dmlFactory.createCTNonVisualDrawingProps();
        CTNonVisualGraphicFrameProperties cNvGraphicFramePr = dmlFactory.createCTNonVisualGraphicFrameProperties();
        CTGraphicalObjectFrameLocking graphicFrameLocks = new CTGraphicalObjectFrameLocking();
        CTTransform2D xfrm = dmlFactory.createCTTransform2D();
        Graphic graphic = dmlFactory.createGraphic();
        GraphicData graphicData = dmlFactory.createGraphicData();
        graphicFrame.setNvGraphicFramePr(nvGraphicFramePr);
        nvGraphicFramePr.setCNvPr(cNvPr);
        cNvPr.setName("nvGraphicFrame " + shape_id);
        cNvPr.setId(shape_id);
        nvGraphicFramePr.setCNvGraphicFramePr(cNvGraphicFramePr);
        cNvGraphicFramePr.setGraphicFrameLocks(graphicFrameLocks);
        graphicFrameLocks.setNoGrp(Boolean.valueOf(true));
        nvGraphicFramePr.setNvPr(pmlFactory.createNvPr());
        graphicFrame.setXfrm(xfrm);
        graphicFrame.setGraphic(graphic);
        graphic.setGraphicData(graphicData);
        graphicData.setUri("http://schemas.openxmlformats.org/drawingml/2006/table");
        CTTable ctTable = this.getPptxTbl(new Double(width / (long)this.ncol).longValue());
        JAXBElement tbl = dmlFactory.createTbl(ctTable);
        graphicData.getAny().add(tbl);
        return graphicFrame;
    }

    public Tbl getDocxTbl() {
        Tbl newTable = new Tbl();
        this.HeaderDOCX(newTable);
        this.BodyDOCX(newTable);
        this.FooterDOCX(newTable);
        TblPr tblpr = new TblPr();
        Jc alignment = new Jc();
        alignment.setVal(JcEnumeration.CENTER);
        tblpr.setJc(alignment);
        tblpr.setTblLayout(this.getCTTblLayoutType());
        newTable.setTblGrid(this.getTblGrid());
        newTable.setTblPr(tblpr);
        return newTable;
    }

    @Override
    public String getHTML() {
        String out = "<table>";
        if (this.widths[0] > 0.0) {
            int j = 0;
            while (j < this.ncol) {
                out = String.valueOf(out) + "<col width=\"" + (int)(72.2 * this.widths[j]) + "\">";
                ++j;
            }
        }
        out = String.valueOf(out) + this.HeaderHTML();
        out = String.valueOf(out) + this.BodyHTML();
        out = String.valueOf(out) + this.FooterHTML();
        out = String.valueOf(out) + "</table>";
        return out;
    }

    @Override
    public String getCSS() {
        return "";
    }

    @Override
    public String getJS() {
        return "";
    }

    @Override
    public boolean hasJS() {
        return false;
    }

    @Override
    public boolean hasHTML() {
        return true;
    }

    @Override
    public boolean hasCSS() {
        return false;
    }
}

