/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts;

public class LanguageTagToScriptMapping {
    public static String getScriptForLanguageTag(String langTag) {
        String lang = langTag;
        int pos = lang.indexOf(45);
        if (pos > -1) {
            lang = lang.substring(0, pos);
        }
        if (lang.equals("ja")) {
            return "Jpan";
        }
        if (lang.equals("ko")) {
            return "Hang";
        }
        if (lang.equals("zh")) {
            if (langTag.equals("zh_CN") || langTag.equals("zh_SG")) {
                return "Hans";
            }
            return "Hant";
        }
        if (lang.equals("ar")) {
            return "Arab";
        }
        if ("he,yi,iw".contains(lang)) {
            return "Hebr";
        }
        if (lang.equals("th")) {
            return "Thai";
        }
        if ("ti,bwo,eth,kxh,mdy".contains(lang)) {
            return "Ethi";
        }
        if ("bn,as,mni".contains(lang)) {
            return "Beng";
        }
        if (lang.equals("gu")) {
            return "Gujr";
        }
        if (lang.equals("km")) {
            return "Khmr";
        }
        if (lang.equals("kn")) {
            return "Knda";
        }
        if (lang.equals("pa")) {
            return "Guru";
        }
        if (lang.equals("iu")) {
            return "Cans";
        }
        if (lang.equals("chr")) {
            return "Cher";
        }
        if (lang.equals("bo")) {
            return "Tibt";
        }
        if (lang.equals("dv")) {
            return "Thaa";
        }
        if ("hi,ks,kok,mr,ne,sa,sd".contains(lang)) {
            return "Deva";
        }
        if (lang.equals("te")) {
            return "Telu";
        }
        if (lang.equals("ta")) {
            return "Taml";
        }
        if (lang.equals("syr")) {
            return "Syrc";
        }
        if (lang.equals("or")) {
            return "Orya";
        }
        if (lang.equals("ml")) {
            return "Mlym";
        }
        if (lang.equals("lo")) {
            return "Laoo";
        }
        if (lang.equals("si")) {
            return "Sinh";
        }
        if (lang.equals("vi") || lang.equals("lha") || lang.equals("nut")) {
            return "Viet";
        }
        if (lang.equals("ka")) {
            return "Geor";
        }
        return null;
    }
}

