/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.jpeg.xmp;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.common.byteSources.ByteSource;
import org.apache.sanselan.common.byteSources.ByteSourceArray;
import org.apache.sanselan.common.byteSources.ByteSourceFile;
import org.apache.sanselan.common.byteSources.ByteSourceInputStream;
import org.apache.sanselan.formats.jpeg.xmp.JpegRewriter;

public class JpegXmpRewriter
extends JpegRewriter {
    public void removeXmpXml(File src, OutputStream os) throws ImageReadException, IOException, ImageWriteException {
        ByteSourceFile byteSource = new ByteSourceFile(src);
        this.removeXmpXml(byteSource, os);
    }

    public void removeXmpXml(byte[] src, OutputStream os) throws ImageReadException, IOException, ImageWriteException {
        ByteSourceArray byteSource = new ByteSourceArray(src);
        this.removeXmpXml(byteSource, os);
    }

    public void removeXmpXml(InputStream src, OutputStream os) throws ImageReadException, IOException, ImageWriteException {
        ByteSourceInputStream byteSource = new ByteSourceInputStream(src, null);
        this.removeXmpXml(byteSource, os);
    }

    public void removeXmpXml(ByteSource byteSource, OutputStream os) throws ImageReadException, IOException, ImageWriteException {
        JpegRewriter.JFIFPieces jfifPieces = this.analyzeJFIF(byteSource);
        List pieces = jfifPieces.pieces;
        pieces = this.removeXmpSegments(pieces);
        this.writeSegments(os, pieces);
    }

    public void updateXmpXml(byte[] src, OutputStream os, String xmpXml) throws ImageReadException, IOException, ImageWriteException {
        ByteSourceArray byteSource = new ByteSourceArray(src);
        this.updateXmpXml(byteSource, os, xmpXml);
    }

    public void updateXmpXml(InputStream src, OutputStream os, String xmpXml) throws ImageReadException, IOException, ImageWriteException {
        ByteSourceInputStream byteSource = new ByteSourceInputStream(src, null);
        this.updateXmpXml(byteSource, os, xmpXml);
    }

    public void updateXmpXml(File src, OutputStream os, String xmpXml) throws ImageReadException, IOException, ImageWriteException {
        ByteSourceFile byteSource = new ByteSourceFile(src);
        this.updateXmpXml(byteSource, os, xmpXml);
    }

    public void updateXmpXml(ByteSource byteSource, OutputStream os, String xmpXml) throws ImageReadException, IOException, ImageWriteException {
        int segmentSize;
        JpegRewriter.JFIFPieces jfifPieces = this.analyzeJFIF(byteSource);
        List pieces = jfifPieces.pieces;
        pieces = this.removeXmpSegments(pieces);
        ArrayList<JpegRewriter.JFIFPieceSegment> newPieces = new ArrayList<JpegRewriter.JFIFPieceSegment>();
        byte[] xmpXmlBytes = xmpXml.getBytes("utf-8");
        for (int index = 0; index < xmpXmlBytes.length; index += segmentSize) {
            segmentSize = Math.min(xmpXmlBytes.length, 65535);
            byte[] segmentData = this.writeXmpSegment(xmpXmlBytes, index, segmentSize);
            newPieces.add(new JpegRewriter.JFIFPieceSegment(65505, segmentData));
        }
        pieces = this.insertAfterLastAppSegments(pieces, newPieces);
        this.writeSegments(os, pieces);
    }

    private byte[] writeXmpSegment(byte[] xmpXmlData, int start, int length) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        os.write(XMP_IDENTIFIER);
        os.write(xmpXmlData, start, length);
        return os.toByteArray();
    }
}

