/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.WordprocessingML;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.apache.commons.io.IOUtils;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.io3.stores.PartStore;
import org.docx4j.openpackaging.parts.ExternalTarget;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.utils.BufferUtil;

public class BinaryPart
extends Part {
    ExternalTarget externalTarget = null;
    private ByteBuffer bb;
    private Reference<ByteBuffer> bbRef = null;

    public BinaryPart(PartName partName) throws InvalidFormatException {
        super(partName);
    }

    public BinaryPart(ExternalTarget externalTarget) {
        this.externalTarget = externalTarget;
    }

    public ExternalTarget getExternalTarget() {
        return this.externalTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBinaryData(InputStream binaryData) {
        log.debug("reading input stream");
        try {
            this.bb = BufferUtil.readInputStream(binaryData);
            log.debug(".. done");
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                log.debug("closing binary input stream");
                binaryData.close();
                log.info(".. closed.");
            }
            catch (Exception nested) {
                log.error(nested.getMessage(), (Throwable)nested);
            }
        }
    }

    public void setBinaryData(byte[] bytes) {
        this.bb = ByteBuffer.wrap(bytes);
    }

    public void setBinaryData(ByteBuffer bb) {
        this.bb = bb;
    }

    public boolean isLoaded() {
        if (this.bb != null) {
            return true;
        }
        return this.bbRef != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ByteBuffer getBuffer() {
        ByteBuffer res;
        block16: {
            res = null;
            if (this.bb != null) {
                res = this.bb;
            } else {
                ByteBuffer byteBuffer = res = this.bbRef != null ? this.bbRef.get() : null;
                if (this.getPackage() == null) {
                    log.warn("No package owns this part.");
                    return null;
                }
                PartStore partStore = this.getPackage().getSourcePartStore();
                if (partStore == null) {
                    log.warn("No PartStore configured for this package");
                    return null;
                }
                if (res == null) {
                    InputStream is = null;
                    try {
                        String name = this.partName.getName();
                        try {
                            this.setContentLengthAsLoaded(partStore.getPartSize(name.substring(1)));
                        }
                        catch (UnsupportedOperationException uoe) {
                            // empty catch block
                        }
                        is = partStore.loadPart(name.substring(1));
                        if (is == null) {
                            log.warn(name + " missing from part store");
                        } else {
                            res = BufferUtil.readInputStream(is);
                            this.bbRef = new SoftReference<ByteBuffer>(res);
                        }
                        IOUtils.closeQuietly((InputStream)is);
                    }
                    catch (Docx4JException e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                    catch (IOException e2) {
                        log.error(e2.getMessage(), (Throwable)e2);
                        break block16;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        IOUtils.closeQuietly(is);
                    }
                }
            }
        }
        res.rewind();
        return res;
    }

    public void writeDataToOutputStream(OutputStream out) throws IOException {
        ByteBuffer buf = this.getBuffer();
        buf.rewind();
        WritableByteChannel channel = Channels.newChannel(out);
        channel.write(buf);
        buf.rewind();
    }

    public byte[] getBytes() {
        ByteBuffer bb = this.getBuffer();
        bb.rewind();
        byte[] bytes = new byte[bb.limit()];
        bb.get(bytes, 0, bytes.length);
        bb.rewind();
        return bytes;
    }

    public boolean isContentEqual(Part other) throws Docx4JException {
        if (!(other instanceof BinaryPart)) {
            return false;
        }
        ByteBuffer thisBB = this.getBuffer();
        ByteBuffer thatBB = ((BinaryPart)other).getBuffer();
        return thisBB.equals(thatBB);
    }
}

