/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.WordprocessingML;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.docx4j.fonts.PhysicalFonts;
import org.docx4j.fonts.fop.fonts.CustomFont;
import org.docx4j.fonts.fop.fonts.EncodingMode;
import org.docx4j.fonts.fop.fonts.FontLoader;
import org.docx4j.fonts.fop.fonts.FontResolver;
import org.docx4j.fonts.fop.fonts.FontSetup;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObfuscatedFontPart
extends BinaryPart {
    private static Logger log = LoggerFactory.getLogger(ObfuscatedFontPart.class);
    private static final String DOCX4J_USER_DIR = ".docx4all";
    private static final String TEMPORARY_FONT_DIR = "temporary embedded fonts";
    private static File tmpFontDir = null;
    static CharSequence target;
    static CharSequence replacement;

    public static String getTemporaryEmbeddedFontsDir() {
        try {
            return tmpFontDir.getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static File getUserHome() {
        File userDir;
        String s = System.getProperty("user.home");
        if (s != null && (userDir = new File(s)).exists()) {
            return userDir;
        }
        return null;
    }

    public ObfuscatedFontPart(PartName partName) throws InvalidFormatException {
        super(partName);
        this.init();
    }

    public void init() {
        this.setContentType(new ContentType("application/vnd.openxmlformats-officedocument.obfuscatedFont"));
    }

    public void deObfuscate(String fontName, String fontKey) {
        byte[] fontData = this.getBytes();
        log.debug("bytes: " + fontData.length);
        log.info("deObfuscating with fontkey: " + fontKey);
        String tmpString = fontKey.substring(1, fontKey.length() - 1);
        log.debug(tmpString);
        String guidString = tmpString.replace(target, replacement);
        log.debug(guidString);
        byte[] guidByteArray = new byte[16];
        for (int i = 0; i < guidByteArray.length; ++i) {
            guidByteArray[i] = ObfuscatedFontPart.fromHexString(guidString.substring(i * 2, i * 2 + 2));
        }
        for (int j = 0; j < 2; ++j) {
            for (int i = 0; i < 16; ++i) {
                int n = j * 16 + i;
                fontData[n] = (byte)(fontData[n] ^ guidByteArray[15 - i]);
            }
        }
        File f = new File(tmpFontDir, fontName + ".ttf");
        String path = null;
        FileOutputStream fos = null;
        try {
            path = f.getCanonicalPath();
            fos = new FileOutputStream(f);
            fos.write(fontData);
            log.debug("wrote: " + fontData.length);
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        log.info("Done!");
        FontResolver fontResolver = FontSetup.createMinimalFontResolver();
        if (log.isDebugEnabled()) {
            CustomFont customFont = null;
            try {
                log.debug("Loading from: " + path);
                String subFontName = null;
                boolean embedded = true;
                boolean useKerning = true;
                customFont = FontLoader.loadFont("file:" + path, subFontName, embedded, EncodingMode.AUTO, useKerning, fontResolver);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (customFont != null) {
                log.info("Successfully reloaded " + customFont.getFontName());
                if (customFont.isEmbeddable()) {
                    log.debug("confirmed embeddable");
                } else {
                    log.error("this embedded font claims it is not embeddable!");
                }
            }
        }
        try {
            PhysicalFonts.addPhysicalFont(fontName, new URL("file:" + path));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public static byte fromHexString(String hexStr) {
        byte firstNibble = Byte.parseByte(hexStr.substring(0, 1), 16);
        byte secondNibble = Byte.parseByte(hexStr.substring(1, 2), 16);
        int finalByte = secondNibble | firstNibble << 4;
        return (byte)finalByte;
    }

    static {
        File userHome = ObfuscatedFontPart.getUserHome();
        if (userHome != null) {
            File docx4jUserDir = new File(userHome, DOCX4J_USER_DIR);
            docx4jUserDir.mkdir();
            tmpFontDir = new File(docx4jUserDir, TEMPORARY_FONT_DIR);
            tmpFontDir.mkdir();
        }
        target = new String("-").subSequence(0, 1);
        replacement = new String("").subSequence(0, 0);
    }
}

