% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkgDep.R
\name{.installed.pkgs}
\alias{.installed.pkgs}
\title{Partial alternative (faster) to \code{installed.packages}}
\usage{
.installed.pkgs(
  lib.loc = .libPaths(),
  which = c("Depends", "Imports", "LinkingTo"),
  other = NULL,
  purge = getOption("Require.purge", FALSE),
  packages = NULL,
  collapse = FALSE
)
}
\arguments{
\item{lib.loc}{
    character vector describing the location of \R library trees to
    search through, or \code{NULL} for all known trees
    (see \code{\link{.libPaths}}).
  }

\item{which}{a character vector listing the types of dependencies, a subset
of \code{c("Depends", "Imports", "LinkingTo", "Suggests", "Enhances")}.
Character string \code{"all"} is shorthand for that vector, character string
\code{"most"} for the same vector without \code{"Enhances"}.}

\item{other}{Can supply other fields; the only benefit here is that a user
can specify \code{"github"} (lower case) and it will automatically add
c("GithubRepo", "GithubUsername", "GithubRef", "GithubSHA1",
"GithubSubFolder") fields}

\item{purge}{Logical. Should all caches be purged? Default is
\code{getOption("Require.purge", FALSE)}. There is a lot of internal caching of
results throughout the \code{Require} package. These help with speed and reduce
calls to internet sources. However, sometimes these caches must be purged.
The cached values are renewed when found to be too old, with the age limit.
This maximum age can be set in seconds with the environment variable
\code{R_AVAILABLE_PACKAGES_CACHE_CONTROL_MAX_AGE}, or if unset, defaults to 3600
(one hour -- see \code{\link[utils:available.packages]{utils::available.packages}}).

Internally, there are calls to \code{available.packages}.}

\item{packages}{Character vector. If \code{NULL} (default), then all installed packages
are searched for. If a character vector is supplied, then it will only return
information about those packages (and is thus faster to execute).}

\item{collapse}{Logical. If \code{TRUE} then the dependency fields will be collapsed;
if \code{FALSE} (default) then the \code{which} fields will be kept separate.}
}
\description{
This reads the DESCRIPTION files only, so can only access fields that are
available in the DESCRIPTION file. This is different than \code{installed.packages}
which has many other fields, like "Built", "NeedsCompilation" etc. If those
fields are needed, then this function will return an empty column in the returned
character matrix.
}
