% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/database_tables_omop.R
\name{omop_tables}
\alias{omop_tables}
\alias{omop_table_all_patients}
\alias{omop_table_condition_era}
\alias{omop_table_condition_occurrence}
\alias{omop_table_death}
\alias{omop_table_device_exposure}
\alias{omop_table_dose_era}
\alias{omop_table_drug_era}
\alias{omop_table_drug_exposure}
\alias{omop_table_measurement}
\alias{omop_table_note}
\alias{omop_table_observation}
\alias{omop_table_observation_period}
\alias{omop_table_payer_plan_period}
\alias{omop_table_procedure_occurrence}
\alias{omop_table_specimen}
\alias{omop_table_visit_occurrence}
\title{OMOP Tables}
\usage{
omop_table_all_patients(table_map, db_connection)

omop_table_condition_era(table_map, db_connection, subject_id)

omop_table_condition_occurrence(table_map, db_connection, subject_id)

omop_table_death(table_map, db_connection, subject_id)

omop_table_device_exposure(table_map, db_connection, subject_id)

omop_table_dose_era(table_map, db_connection, subject_id)

omop_table_drug_era(table_map, db_connection, subject_id)

omop_table_drug_exposure(table_map, db_connection, subject_id)

omop_table_measurement(table_map, db_connection, subject_id)

omop_table_note(table_map, db_connection, subject_id)

omop_table_observation(table_map, db_connection, subject_id)

omop_table_observation_period(table_map, db_connection, subject_id)

omop_table_payer_plan_period(table_map, db_connection, subject_id)

omop_table_procedure_occurrence(table_map, db_connection, subject_id)

omop_table_specimen(table_map, db_connection, subject_id)

omop_table_visit_occurrence(table_map, db_connection, subject_id)
}
\arguments{
\item{table_map}{A \link[dplyr:reexports]{dplyr::tibble} containing a mapping between the CDM standard
tables and fields to the user connected tables and fields.}

\item{db_connection}{A \link[DBI:dbConnect]{DBI::dbConnect} object}

\item{subject_id}{A numeric, or coercible to numeric.}
}
\value{
A \link[dplyr:reexports]{dplyr::tibble} containing pre-coordinated patient information from the connected database.
}
\description{
Collection of functions to create prearranged views of OMOP patient data
when supplied with database connection information and a mapping of the connected
database.
}
\keyword{internal}
