% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/database_tables_omop.R
\name{get_concept}
\alias{get_concept}
\title{OMOP Get Concept}
\usage{
get_concept(
  table_map,
  db_connection,
  concept_table,
  concept_id,
  concept_name,
  table,
  joinable_id,
  table_concept_id,
  col_name,
  subject_id_field = NULL,
  selected_subject = NULL
)
}
\arguments{
\item{table_map}{A \link[dplyr:reexports]{dplyr::tibble} containing a mapping between the CDM standard
tables and fields to the user connected tables and fields.}

\item{db_connection}{A \link[DBI:dbConnect]{DBI::dbConnect} object.}

\item{concept_table}{A string, containing the standard CDM concept table name.}

\item{concept_id}{A string, containing the standard CDM concept id field.}

\item{concept_name}{A string, containing the standard CDM concept name field.}

\item{table}{A string, containing the table name that requires OMOP concepts.}

\item{joinable_id}{A string, indicating what variable is "joinable" between the concept
table and the desired table.}

\item{table_concept_id}{A string, containing the the table concept id}

\item{col_name}{A string, containing the desired name for the retrieved concept.}

\item{subject_id_field}{A string, identifying which table field contains the subject id.}

\item{selected_subject}{A numeric, or coercible to numeric containing the desired
subject id.}
}
\value{
The desired OMOP concept based on the user data model for all subjects
}
\description{
This function assists with transforming OMOP concept_ids to interpretable strings
by retrieving the requested concepts from the appropriate OMOP concept table.
}
\keyword{internal}
