% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{checkAuthentication}
\alias{checkAuthentication}
\title{Checks whether the authentication is supported by the server
and handles the different POST request routes.}
\usage{
checkAuthentication(request, auth, version.needed = 1)
}
\arguments{
\item{request}{The needed request to be made (without \code{.cgi}).}

\item{auth}{Whether authentication is requested in R.}

\item{version.needed}{The minimum version of the request. If it is
\code{1}, and the server is version 1, the function will append
\code{.cgi} to the request.}
}
\value{
A list: \enumerate{
\item \code{request}: the request to send
\item \code{auth}: whether to still send an authenticated request.
}
}
\description{
Checks whether the authentication is supported by the server
and handles the different POST request routes.
}
\examples{
checkAuthentication("makecsv", TRUE)
checkAuthentication("registration", TRUE, 2)

}
\seealso{
Other development: \code{\link{API.request}},
  \code{\link{create.API.request.URL}},
  \code{\link{prepare.server.URL}},
  \code{\link{server.version}}
}

