% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plottree.R
\name{plot-forestry}
\alias{plot-forestry}
\alias{plot.forestry}
\title{visualize a tree}
\usage{
\method{plot}{forestry}(x, tree.id = 1, print.meta_dta = FALSE, beta.char.len = 30, ...)
}
\arguments{
\item{x}{A forestry x.}

\item{tree.id}{Specifies the tree number that should be visulaized.}

\item{print.meta_dta}{Should the data for the plot be printed?}

\item{beta.char.len}{The length of the beta values in leaf node
representation.}

\item{...}{additional arguments that are not used.}
}
\description{
plots a tree in the forest.
}
\examples{
set.seed(292315)
rf <- forestry(x = iris[,-1],
               y = iris[, 1])

plot(x = rf)
plot(x = rf, tree.id = 2)
plot(x = rf, tree.id = 500)

ridge_rf <- forestry(
  x = iris[,-1],
  y = iris[, 1],
  replace = FALSE,
  nodesizeStrictSpl = 10,
  mtry = 4,
  ntree = 10,
  minSplitGain = .004,
  linear = TRUE,
  overfitPenalty = 1.65,
  linFeats = 1:2)

plot(x = ridge_rf)
plot(x = ridge_rf, tree.id = 2)
plot(x = ridge_rf, tree.id = 10)

}
