
# Ricetl

徐静（算法工程师)

## 函数调用


Ricetl一共四个方法，一个数据，其中三个方法为包中的隐藏方法，Ricetl实现了R的Gui 身份证特征处理。

+ 安装

    - 目前Ricetl开发版本托管在[Github](https://github.com/DataXujing/Ricetl)上
    - 安装方式： devtools::install_github('DataXujing/Ricetl')
    - 后期稳定版本会上传CRAN

+ 函数调用

    - Ricetl(): 调用Gui界面，提出身份证号特征
    - data(id_card6): 公共数据集，身份证前六位与户籍地址对应关系数据


## 二代身份证编码规则及校验代码实现

### 1.二代身份证号码编码规则
+ 编码格式：1999年我国颁发了第二代居民身份证号，公民身份号码为18位，且终身不变。居民身份证格式如：ABCDEFYYYYMMDDXXXR

+ 地址码（ABCDEF）：表示登记户口时所在地的行政区划代码（省、市、县），如果行政区划进行了重新划分，同一个地方进行户口登记的可能存在地址码不一致的情况。行政区划代码按GB/T2260的规定执行。

+ 出生日期码（YYYYMMDD）：表示该居民的出生年月日，年4位数字，月和日分别用2位数字表示，如19491001，；出生日期码是按GB/T 7408的规定执行的。

+ 顺序码（XXX）：表示同一地址码区域内，同年、同月、同日生的人所编订的顺序号，根据自己身份证的顺序码就可以知道：与我们同年同月同日生的同性至少有多少个，且在我们之前登记户籍的有多少人。身份证顺序码的奇数分配给男性，偶数分配给女性。这就是为什么倒数第二位奇数表示男生，偶数表示女生。

+ 校验码（R）：R之前的17位被称为本体码，R是根据本体码，按照校验码算法(ISO 7064:1983,MOD 11-2校)计算出来的。当我们输入身份号码进行实名认证的时候，根据校验码算法可以初步判断你输入身份证号码格式是否正确。

### 2.校验码算法

将本体码各位数字乘以对应加权因子并求和，除以11得到余数，根据余数通过校验码对照表查得校验码。

+ 加权因子

```r

a <- c('1','2','3','4','5','6','7','8','9','10','11','12','13','14','15','16','17')
       
b <- c('7','9','10','5','8','4','2','2','6','3','7','9','10','5','8','4','2')

dat <- data.frame(a,b)
names(dat) <- c('位置序号','加权因子')
data.frame(t(dat))
```



+ 校验码表

```r

c1 <- c(0,1,2,3,4,5,6,7,8,9,10)
d <- c('1','0','X','9','8','7','6','5','4','3','2')

dat1 <- data.frame(c1,d)
names(dat1) <- c('余数','校验码')
data.frame(t(dat1))
```
