% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ilostat_dic.R
\name{get_ilostat_dic}
\alias{get_ilostat_dic}
\title{Read Ilostat Dictionary}
\usage{
get_ilostat_dic(dic, lang = getOption("ilostat_lang", "en"))
}
\arguments{
\item{dic}{A character, dictionary for the variable to be downloaded,}

\item{lang}{a character, code for language. Available are \code{"en"} (default), 
\code{"fr"} and \code{"es"}. Can be set also with options(ilostat_lang = 'fr'),}
}
\value{
tibble with two columns: code names and full names.
}
\description{
Downloads one ilostat dictionary from ilostat \url{https://ilostat.ilo.org} via bulk download facility 
\url{https://ilostat.ilo.org/data/bulk/}.
}
\details{
For a given coded variable from ilostat \url{https://ilostat.ilo.org/}.
   The dictionaries link codes with human-readable labels.
   To translate codes to labels, use \code{\link{label_ilostat}}.
}
\examples{
\dontrun{
 tmp <- get_ilostat_dic("indicator")
 head(tmp)
 tmp <- get_ilostat_dic("classif1", lang = "fr")
 head(tmp)
}
}
\references{
See citation("ilostat")
ilostat bulk download facility user guidelines 
\url{https://www.ilo.org/ilostat-files/WEB_bulk_download/ILOSTAT_BulkDownload_Guidelines.pdf}
ilostat bulk download facility main page 
\url{https://ilostat.ilo.org/data/bulk/}
}
\seealso{
\code{\link{label_ilostat}}, \code{\link{get_ilostat}}.
}
\author{
David Bescond \email{bescond@ilo.org}
}
\keyword{database}
\keyword{utilities}
