// Tiny Encryption Algorithm
//--------------------------

#include "mixmod/Utilities/Random.h" // prototypes
#include "mixmod/Utilities/Util.h"
#include <sys/timeb.h> // time_t
#include <fstream>

namespace XEM {

// Algorithm implemented for portability 32-64 bits, ...

const double m = 4294967296.0;

const uint32_t d = 0x09E3779B9L;
const uint32_t k0 = 0x0C7D7A8B4L;
const uint32_t k1 = 0x09ABFB3B6L;
const uint32_t k2 = 0x073DC1683L;
const uint32_t k3 = 0x017B7BE43L;

uint32_t y = 123456789L;
uint32_t z = 987654321L;

// Return a value in [0...1[
double rnd() {
	uint32_t s = 0;
	uint32_t n = 8;
	while (n-- > 0) {
		s += d;
		y += (z << 4) + (k0^z) + (s^(z >> 5)) + k1;
		z += (y << 4) + (k2^y) + (s^(y >> 5)) + k3;
	}
	return (z + y / m) / m;
}

int64_t flip(double x) {
	return (rnd() <= x);
}

void initRandomize(int seed)
{
	seed < 0
		? randomize()
		: antiRandomize(seed);
}

// Randomly initialize seeds (non-deterministic runs)
void randomize() {
	timeb q;
	ftime(&q);
	z = (uint32_t) q.millitm;
	y = (uint32_t) q.time;
	rnd();
}

// Use user seed (deterministic runs)
void antiRandomize(int seed) {
	// bijection N-->N^2 by diagonals [TODO: check formulas]
	//1) look for the largest n such that n(n+1)/2 <= seed
	int n = (int)floor(0.5 * (-1.0 + sqrt(1.0 + 8.0 * seed)));
	//2) coordinates are seed-n(n+1)/2, (n+1)(n+2)/2-1-seed
	z = seed - (n*(n+1))/2;
	y = ((n+1)*(n+2))/2 - 1 - seed;
	rnd();
}

}
