\name{surveydetails}
\alias{surveydetails}
\alias{surveyquestions}
\title{Get survey details}
\description{Get details about a specific survey}
\usage{
surveydetails(survey, api_key = getOption('sm_api_key'),
              oauth_token = getOption('sm_oauth_token'), ...)

surveyquestions(survey, details, api_key = getOption('sm_api_key'),
                oauth_token = getOption('sm_oauth_token'), ...)
}
\arguments{
\item{survey}{A Survey Monkey survey ID number (or an object of class \dQuote{sm_survey} from which it can be extracted), possibly returned by \code{\link{surveylist}}. For \code{surveyquestions}, either \code{survey} or \code{details} must be supplied.}
\item{details}{For \code{surveyquestions}, either \code{survey} or \code{details} must be supplied. \code{details} must be supplied as an object of class \code{sm_surveydetails}. If missing, a \code{\link{surveydetails}} request will be executed for the survey supplied in the \code{survey} argument.}
\item{api_key}{Your API key. By default, retrieved from \code{getOption('sm_api_key')}.}
\item{oauth_token}{Your OAuth 2.0 token, as generated by \code{\link{smlogin}}. By default, retrieved from \code{getOption('sm_oauth_token')}.}
\item{...}{Other arguments passed to \code{\link[httr]{POST}}.}
}
\details{
\code{surveydetails} retrieves details of a specified survey (e.g., question metadata). Surveys with over 200 survey pages will not be returned. Surveys with over 200 questions will not be returned.

\code{surveyquestions} extracts a named character vector of question wordings from a \dQuote{sm_surveydetails} object. This can be useful for creating a codebook of responses or for mapping responses (from \code{\link{getresponses}}) to the original question wordings.
}
\value{For \code{surveydetails}, a list of objects of class \code{sm_survey}. For \code{surveyquestions}, a character vector with Survey Monkey question ID values as names.}
\references{
\url{https://developer.surveymonkey.com/mashery/get_survey_details}
}
\author{Thomas J. Leeper}
%\note{}
%\seealso{}
\examples{
\dontrun{
smlogin()
s <- surveylist()

# retrieve all survey details
d <- surveydetails(s[[1]]$survey_id)
d

# retrieve question wordings
surveyquestions(d)
}
}
%\keyword{}
