% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polygons.R
\name{getCtryShpLyrNames}
\alias{getCtryShpLyrNames}
\title{Get the standard names of polygon layers in a country}
\usage{
getCtryShpLyrNames(ctryCodes = NULL, lyrNums, dnldPoly,
  gadmVersion = pkgOptions("gadmVersion"), custPolyPath = NULL)
}
\arguments{
\item{ctryCodes}{the ISO3 codes for the countries}

\item{lyrNums}{the layer numbers starting from 0 = country level, 
1 = first admin level}

\item{dnldPoly}{\code{logical} If the country polygon doesn't exist 
should we download it?}

\item{gadmVersion}{The GADM version to use}

\item{custPolyPath}{Alternative to GADM. A path to a custom shapefile zip}
}
\value{
Character layer name
}
\description{
Get the standard name of a polygon layer for a country. Used to refer 
    to a polygon layer by name i.e. for 
    CTRYCODE & lyrNum="0": lyrName="CTRYCODE_adm0", 
    lyrNum="1": lyrName="KEN_adm1".
    Note this is different from the official country administration
    level name.
}
\examples{
\dontrun{
#requires KEN polygon shapefile to exist in the polygons folder
getCtryShpLyrNames("KEN","1")
  #returns "KEN_adm1"
}

#export only due to exploreData() shiny app
}
