% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RoBMA-reg.R
\name{RoBMA.reg}
\alias{RoBMA.reg}
\title{Estimate a Robust Bayesian Meta-Analysis Meta-Regression}
\usage{
RoBMA.reg(
  formula,
  data,
  test_predictors = TRUE,
  study_names = NULL,
  study_ids = NULL,
  transformation = if (any(colnames(data) != "y")) "fishers_z" else "none",
  prior_scale = if (any(colnames(data) != "y")) "cohens_d" else "none",
  standardize_predictors = TRUE,
  effect_direction = "positive",
  priors = NULL,
  model_type = NULL,
  priors_effect = prior(distribution = "normal", parameters = list(mean = 0, sd = 1)),
  priors_heterogeneity = prior(distribution = "invgamma", parameters = list(shape = 1,
    scale = 0.15)),
  priors_bias = list(prior_weightfunction(distribution = "two.sided", parameters =
    list(alpha = c(1, 1), steps = c(0.05)), prior_weights = 1/12),
    prior_weightfunction(distribution = "two.sided", parameters = list(alpha = c(1, 1,
    1), steps = c(0.05, 0.1)), prior_weights = 1/12), prior_weightfunction(distribution =
    "one.sided", parameters = list(alpha = c(1, 1), steps = c(0.05)), prior_weights =
    1/12), prior_weightfunction(distribution = "one.sided", parameters = list(alpha =
    c(1, 1, 1), steps = c(0.025, 0.05)), prior_weights = 1/12), 
    
    prior_weightfunction(distribution = "one.sided", parameters = list(alpha = c(1, 1,
    1), steps = c(0.05, 0.5)), prior_weights = 1/12), prior_weightfunction(distribution =
    "one.sided", parameters = list(alpha = c(1, 1, 1, 1), steps = c(0.025, 0.05, 0.5)),
    prior_weights = 1/12), prior_PET(distribution = "Cauchy", parameters = list(0, 1),
    truncation = list(0, Inf), prior_weights = 1/4), prior_PEESE(distribution = "Cauchy",
    parameters = list(0, 5), truncation = list(0, Inf), prior_weights = 1/4)),
  priors_effect_null = prior(distribution = "point", parameters = list(location = 0)),
  priors_heterogeneity_null = prior(distribution = "point", parameters = list(location =
    0)),
  priors_bias_null = prior_none(),
  priors_hierarchical = prior("beta", parameters = list(alpha = 1, beta = 1)),
  priors_hierarchical_null = NULL,
  prior_covariates = prior("normal", parameters = list(mean = 0, sd = 0.25)),
  prior_covariates_null = prior("spike", parameters = list(location = 0)),
  prior_factors = prior_factor("mnormal", parameters = list(mean = 0, sd = 0.25),
    contrast = "meandif"),
  prior_factors_null = prior_factor("spike", parameters = list(location = 0), contrast =
    "meandif"),
  chains = 3,
  sample = 5000,
  burnin = 2000,
  adapt = 500,
  thin = 1,
  parallel = FALSE,
  autofit = TRUE,
  autofit_control = set_autofit_control(),
  convergence_checks = set_convergence_checks(),
  save = "all",
  seed = NULL,
  silent = TRUE,
  ...
)
}
\arguments{
\item{formula}{a formula for the meta-regression model}

\item{data}{a data object created by the \code{combine_data} function. This is
an alternative input entry to specifying the \code{d}, \code{r}, \code{y}, etc...
directly. I.e., you cannot pass the a data.frame and reference to the columns.}

\item{test_predictors}{vector of predictor names that will be test
(i.e., assigned both the null and alternative prior distributions).
Defaults to \code{TRUE}, all predictors are tested using the default
prior distributions (i.e., \code{prior_covariates},
\code{prior_covariates_null}, \code{prior_factors}, and
\code{prior_factors_null}). To only estimate
and adjust for the effect of predictors use \code{FALSE}. If
\code{priors} is specified, any settings in \code{test_predictors}
is overridden.}

\item{study_names}{an optional argument with the names of the studies}

\item{study_ids}{an optional argument specifying dependency between the
studies (for using a multilevel model). Defaults to \code{NULL} for
studies being independent.}

\item{transformation}{transformation to be applied to the supplied
effect sizes before fitting the individual models. Defaults to
\code{"fishers_z"}. We highly recommend using \code{"fishers_z"}
transformation since it is the only variance stabilizing measure
and does not bias PET and PEESE style models. The other options are
\code{"cohens_d"}, correlation coefficient \code{"r"} and \code{"logOR"}.
Supplying \code{"none"} will treat the effect sizes as unstandardized and
refrain from any transformations.}

\item{prior_scale}{a scale used to define priors. Defaults to \code{"cohens_d"}.
Other options are \code{"fishers_z"}, correlation coefficient \code{"r"},
and \code{"logOR"}. The prior scale does not need to match the effect sizes measure -
the samples from prior distributions are internally transformed to match the
\code{transformation} of the data. The \code{prior_scale} corresponds to
the scale of default output, but can be changed within the summary function.}

\item{standardize_predictors}{whether continuous predictors should be standardized prior to
estimating the model. Defaults to \code{TRUE}.}

\item{effect_direction}{the expected direction of the effect. The one-sided
selection sets the weights omega to 1 to significant results in the expected
direction. Defaults to \code{"positive"} (another option is \code{"negative"}).}

\item{priors}{named list of prior distributions for each predictor
(with names corresponding to the predictors). It allows users to
specify both the null and alternative hypothesis prior distributions
for each predictor by assigning the corresponding element of the named
list with another named list (with \code{"null"} and
\code{"alt"}).
If only one prior is specified for a given parameter, it is
assumed to correspond to the alternative hypotheses and the default null
hypothesis is specified (i.e., \code{prior_covariates_null} or
\code{prior_factors_null}).
If a named list with only one named prior distribution is provided (either
\code{"null"} or \code{"alt"}), only this prior distribution is used and no
default distribution is filled in.
Parameters without specified prior distributions are assumed to be only adjusted
for using the default alternative hypothesis prior distributions (i.e.,
\code{prior_covariates} or \code{prior_factors}).
If \code{priors} is specified, \code{test_predictors} is ignored.}

\item{model_type}{string specifying the RoBMA ensemble. Defaults to \code{NULL}.
The other options are \code{"PSMA"}, \code{"PP"}, and \code{"2w"} which override
settings passed to the \code{priors_effect}, \code{priors_heterogeneity},
\code{priors_effect}, \code{priors_effect_null}, \code{priors_heterogeneity_null},
\code{priors_bias_null}, and \code{priors_effect}. See details for more information
about the different model types.}

\item{priors_effect}{list of prior distributions for the effect size (\code{mu})
parameter that will be treated as belonging to the alternative hypothesis. Defaults to
a standard normal distribution
\code{prior(distribution = "normal", parameters = list(mean = 0, sd = 1))}.}

\item{priors_heterogeneity}{list of prior distributions for the heterogeneity \code{tau}
parameter that will be treated as belonging to the alternative hypothesis. Defaults to
\code{prior(distribution = "invgamma", parameters = list(shape = 1, scale = .15))} that
is based on heterogeneities estimates from psychology \insertCite{erp2017estimates}{RoBMA}.}

\item{priors_bias}{list of prior distributions for the publication bias adjustment
component that will be treated as belonging to the alternative hypothesis.
Defaults to \code{list(
prior_weightfunction(distribution = "two.sided", parameters = list(alpha = c(1, 1),
    steps = c(0.05)),             prior_weights = 1/12),
prior_weightfunction(distribution = "two.sided", parameters = list(alpha = c(1, 1, 1),
    steps = c(0.05, 0.10)),       prior_weights = 1/12),
prior_weightfunction(distribution = "one.sided", parameters = list(alpha = c(1, 1),
     steps = c(0.05)),             prior_weights = 1/12),
prior_weightfunction(distribution = "one.sided", parameters = list(alpha = c(1, 1, 1),
     steps = c(0.025, 0.05)),      prior_weights = 1/12),
prior_weightfunction(distribution = "one.sided", parameters = list(alpha = c(1, 1, 1),
     steps = c(0.05, 0.5)),        prior_weights = 1/12),
prior_weightfunction(distribution = "one.sided", parameters = list(alpha = c(1, 1, 1, 1),
     steps = c(0.025, 0.05, 0.5)), prior_weights = 1/12),
prior_PET(distribution   = "Cauchy", parameters = list(0,1), truncation = list(0, Inf),
     prior_weights = 1/4),
prior_PEESE(distribution = "Cauchy", parameters = list(0,5), truncation = list(0, Inf),
     prior_weights = 1/4)
)}, corresponding to the RoBMA-PSMA model introduce by \insertCite{bartos2021no;textual}{RoBMA}.}

\item{priors_effect_null}{list of prior distributions for the effect size (\code{mu})
parameter that will be treated as belonging to the null hypothesis. Defaults to
a point null hypotheses at zero,
\code{prior(distribution = "point", parameters = list(location = 0))}.}

\item{priors_heterogeneity_null}{list of prior distributions for the heterogeneity \code{tau}
parameter that will be treated as belonging to the null hypothesis. Defaults to
a point null hypotheses at zero (a fixed effect meta-analytic models),
\code{prior(distribution = "point", parameters = list(location = 0))}.}

\item{priors_bias_null}{list of prior weight functions for the \code{omega} parameter
that will be treated as belonging to the null hypothesis. Defaults no publication
bias adjustment, \code{prior_none()}.}

\item{priors_hierarchical}{list of prior distributions for the correlation of random effects
(\code{rho}) parameter that will be treated as belonging to the alternative hypothesis. This setting allows
users to fit a hierarchical (three-level) meta-analysis when \code{study_ids} are supplied.
Note that this is an experimental feature and see News for more details. Defaults to a beta distribution
\code{prior(distribution = "beta", parameters = list(alpha = 1, beta = 1))}.}

\item{priors_hierarchical_null}{list of prior distributions for the correlation of random effects
(\code{rho}) parameter that will be treated as belonging to the null hypothesis. Defaults to \code{NULL}.}

\item{prior_covariates}{a prior distributions for the regression parameter
of continuous covariates on the effect size under the alternative hypothesis
(unless set explicitly in \code{priors}). Defaults to a relatively wide normal
distribution \code{prior(distribution = "normal", parameters = list(mean = 0, sd = 0.25))}.}

\item{prior_covariates_null}{a prior distributions for the regression parameter
of continuous covariates on the effect size under the null hypothesis
(unless set explicitly in \code{priors}). Defaults to a no effect
\code{prior("spike",  parameters = list(location = 0))}.}

\item{prior_factors}{a prior distributions for the regression parameter
of categorical covariates on the effect size under the alternative hypothesis
(unless set explicitly in \code{priors}). Defaults to a relatively wide
multivariate normal distribution specifying differences from the mean contrasts
\code{prior_factor("mnormal", parameters = list(mean = 0, sd = 0.25), contrast = "meandif")}.}

\item{prior_factors_null}{a prior distributions for the regression parameter
of categorical covariates on the effect size under the null hypothesis
(unless set explicitly in \code{priors}). Defaults to a no effect
\code{prior("spike",  parameters = list(location = 0))}.}

\item{chains}{a number of chains of the MCMC algorithm.}

\item{sample}{a number of sampling iterations of the MCMC algorithm.
Defaults to \code{5000}.}

\item{burnin}{a number of burnin iterations of the MCMC algorithm.
Defaults to \code{2000}.}

\item{adapt}{a number of adaptation iterations of the MCMC algorithm.
Defaults to \code{500}.}

\item{thin}{a thinning of the chains of the MCMC algorithm. Defaults to
\code{1}.}

\item{parallel}{whether the individual models should be fitted in parallel.
Defaults to \code{FALSE}. The implementation is not completely stable
and might cause a connection error.}

\item{autofit}{whether the model should be fitted until the convergence
criteria (specified in \code{autofit_control}) are satisfied. Defaults to
\code{TRUE}.}

\item{autofit_control}{allows to pass autofit control settings with the
\code{\link[=set_autofit_control]{set_autofit_control()}} function. See \code{?set_autofit_control} for
options and default settings.}

\item{convergence_checks}{automatic convergence checks to assess the fitted
models, passed with \code{\link[=set_convergence_checks]{set_convergence_checks()}} function. See
\code{?set_convergence_checks} for options and default settings.}

\item{save}{whether all models posterior distributions should be kept
after obtaining a model-averaged result. Defaults to \code{"all"} which
does not remove anything. Set to \code{"min"} to significantly reduce
the size of final object, however, some model diagnostics and further
manipulation with the object will not be possible.}

\item{seed}{a seed to be set before model fitting, marginal likelihood
computation, and posterior mixing for reproducibility of results. Defaults
to \code{NULL} - no seed is set.}

\item{silent}{whether all print messages regarding the fitting process
should be suppressed. Defaults to \code{TRUE}. Note that \code{parallel = TRUE}
also suppresses all messages.}

\item{...}{additional arguments.}
}
\value{
\code{RoBMA.reg} returns an object of class 'RoBMA.reg'.
}
\description{
\code{RoBMA} is used to estimate a Robust Bayesian
Meta-Analysis. The interface allows a complete customization of
the ensemble with different prior (or list of prior) distributions
for each component.
}
\details{
See \code{\link[=RoBMA]{RoBMA()}} for more details.

Note that these default prior distributions are relatively wide and more informed
prior distributions for testing for the presence of moderation should be considered.
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=RoBMA]{RoBMA()}} \code{\link[=summary.RoBMA]{summary.RoBMA()}}, \code{\link[=update.RoBMA]{update.RoBMA()}}, \code{\link[=check_setup.reg]{check_setup.reg()}}
}
