% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marginal.R
\name{marginal_summary}
\alias{marginal_summary}
\title{Summarize marginal estimates of a fitted RoBMA regression object}
\usage{
marginal_summary(
  object,
  conditional = FALSE,
  output_scale = NULL,
  probs = c(0.025, 0.975),
  logBF = FALSE,
  BF01 = FALSE
)
}
\arguments{
\item{object}{a fitted RoBMA regression object}

\item{conditional}{show the conditional estimates (assuming that the
alternative is true).}

\item{output_scale}{transform the  meta-analytic estimates to a different
scale. Defaults to \code{NULL} which returns the same scale as the model was estimated on.}

\item{probs}{quantiles of the posterior samples to be displayed.
Defaults to \code{c(.025, .975)}}

\item{logBF}{show log of Bayes factors. Defaults to \code{FALSE}.}

\item{BF01}{show Bayes factors in support of the null hypotheses. Defaults to
\code{FALSE}.}
}
\value{
\code{marginal_summary} returns a list of tables of class 'BayesTools_table'.
}
\description{
\code{marginal_summary} creates summary tables for
marginal estimates of a RoBMA regression model.
}
\seealso{
\code{\link[=RoBMA]{RoBMA()}}, \code{\link[=summary.RoBMA]{summary.RoBMA()}}, \code{\link[=diagnostics]{diagnostics()}}, \code{\link[=check_RoBMA]{check_RoBMA()}}
}
