\name{BC.LU.approximation.RST}
\alias{BC.LU.approximation.RST}
\title{The lower and upper approximation based on rough set}
\usage{
  BC.LU.approximation.RST(decision.table, IND,
    decision.attr = NULL)
}
\arguments{
  \item{decision.table}{a \code{"DecisionTable"} class
  representing the decision table. See
  \code{\link{SF.asDecisionTable}}.}

  \item{IND}{an \code{"IndiscernibilityRelation"} class
  representing the partitions of the indiscernibility
  relation.}

  \item{decision.attr}{a numeric expressing a column index
  which refers to the decision attribute. It should be
  noted that in this case, the decision attributes
  considered must be nominal, otherwise the discretization
  task must be performed first. The default value is
  \code{NULL} which means the last column is the decision
  attribute.}
}
\value{
  A class \code{"LowerUpperApproximation"} representing
  rough set (lower and upper approximation). It contains
  the following components: \itemize{ \item
  \code{lower.approximation}: a list containing object
  indexes included in lower approximations based on
  decision concepts.  \item \code{upper.approximation}: a
  list containing object indexes included in upper
  approximations based on decision concepts.  \item
  \code{type.model}: a string showing type of the used
  model. In this case, it is \code{"RST"} means rough set
  theory.  }
}
\description{
  This is a function that implements a fundamental part of
  rough set theory: lower and upper approximations. The
  lower and upper approximations determine whether the
  objects can be certainty or possibly classified in a
  particular class based on the basis of available
  knowledge. The detailed theoretical description can be
  seen in \code{\link{A.Introduction-RoughSets}}.
}
\details{
  This function depends on
  \code{\link{BC.IND.relation.RST}} which calculates the
  equivalence classes of the indiscernibility relation. So,
  it is obvious that before performing this function, users
  must execute \code{\link{BC.IND.relation.RST}} first.
  Furthermore, we provide parameter \code{decision.attr}
  representing a column index of the decision attribute, so
  actually, users may choose any index to be considered as
  the decision attribute.
}
\examples{
#######################################
## Example: Using simple data set
#######################################
dt.ex1 <- data.frame(c(1,0,2,1,1,2,2,0), c(0, 1,0, 1,0,2,1,1),
                        c(2,1,0,0,2,0,1,1), c(2,1,1,2,0,1,1,0), c(0,2,1,2,1,1,2,1))
colnames(dt.ex1) <- c("aa", "bb", "cc", "dd", "ee")
decision.table <- SF.asDecisionTable(dataset = dt.ex1, decision.attr = 5,
                                     indx.nominal = c(1:5))

P <- c(2,3)

####### Compute indiscernibility relation #######
IND <- BC.IND.relation.RST(decision.table, attribute = P)

####### Compute lower and upper approximation #####
decision.attr <- c(5)
roughset <- BC.LU.approximation.RST(decision.table, IND, decision.attr)
}
\references{
  Z. Pawlak, "Rough Sets", International Journal of
  Computer and Information Sciences, vol. 11, no. 5, p. 341
  - 356 (1982).
}
\seealso{
  \code{\link{BC.IND.relation.RST}},
  \code{\link{BC.LU.approximation.FRST}}
}

