% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_mixture_marginal.R
\name{plot_mixture_marginal}
\alias{plot_mixture_marginal}
\title{Plotting marginal mixing distributions.}
\usage{
plot_mixture_marginal(
  mean_est,
  mean_true = NULL,
  weight_est,
  weight_true = NULL,
  sd_est,
  sd_true = NULL,
  cov_name = NULL
)
}
\arguments{
\item{mean_est}{A list of length \code{C}, where each element is an estimated class mean.}

\item{mean_true}{Either \code{NULL} or a list of length \code{C}, where each element is a true
class mean.}

\item{weight_est}{A numeric vector of length \code{C} with estimated class weights.}

\item{weight_true}{Either \code{NULL} or a numeric vector of length \code{C} with true class
weights.}

\item{sd_est}{A list of length \code{C}, where each element is an estimated class standard
deviation.}

\item{sd_true}{Either \code{NULL} or a list of length \code{C}, where each element is a true
class standard deviation.}

\item{cov_name}{Either \code{NULL} or the name of the corresponding covariate.}
}
\value{
No return value. Draws a plot to the current device.
}
\description{
This function plots the estimated mixing distributions with respect to one
covariate and adds the true marginal mixing distribution for comparison if
available.
}
\keyword{internal}
