% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_raven.R
\name{run_raven}
\alias{run_raven}
\title{Open sound files in 'Raven' sound analysis software}
\usage{
run_raven(raven.path = NULL, sound.files = NULL, path = NULL, at.the.time = 10,
import = FALSE, redo = FALSE, view.preset = NULL, pb = TRUE, ...)
}
\arguments{
\item{raven.path}{A character string indicating the path of the directory in which to look for the 'Raven' executable file (where 'Raven' was installed).}

\item{sound.files}{character vector indicating the files that will be analyzed. If  \code{NULL} (default) then 'Raven' will be run without opening any file.}

\item{path}{A character string indicating the path of the directory in which to look for
the sound files. If not provided (default) the function searches into the current working 
directory. Default is \code{NULL}.}

\item{at.the.time}{Numeric vector of length 1 controling how many files will be open in
'Raven' at the same time. Note that opening too many files at once could make 'Raven' run out
of memory. You need to close 'Raven' every time the batch of files is analyzed, so the next
batch is opened. Default is 10. Not available in OSX (mac).}

\item{import}{Logical. Controls if the selection tables generated should be returned as a 
data frame into the R environment. This only works if the selections are saved in the 
"Selections" folder in the 'Raven' directory. This argument calls the \code{\link{imp_raven}}
internally. Additional arguments can be passed to \code{\link{imp_raven}} to control the way the data is imported.}

\item{redo}{Logical. Controls whether only the subset of files with no 'Raven' selections (.txt file) in the 'Raven' 'selections' folder
are analyzed (if \code{FALSE}). Useful when resuming the analysis. Default is \code{FALSE}.}

\item{view.preset}{Character string defining the 'Raven' view preset to be used.
It should match exactly the name of the present in the 'Raven' folder 'Presets/Sound Window'. If not provided the default view preset is used.}

\item{pb}{Logical argument to control progress bar. Default is \code{TRUE}.}

\item{...}{Additional arguments to be passed to \code{\link{imp_raven}} for customizing
how selections are imported (ignored if \code{import = FALSE}).}
}
\value{
If \code{import = TRUE} a data frame with the selections produced during the analysis will be return as an data frame. See \code{\link{imp_raven}} for more details on how selections are imported.
}
\description{
\code{run_raven} opens several sound files in 'Raven' sound analysis software
}
\details{
The function runs 'Raven' sound analysis software (Cornell Lab of
Ornithology), opening many files simultaneously. 'Raven' will still run if no
sound files are provided (i.e. \code{sound.files = NULL}). At the end of the
analysis the data can be automatically imported back into R using the 'import'
argument. 'Raven' Pro must be installed. Note that 'Raven' can also take sound files in 'mp3', 'flac' and
'aif' format.
}
\examples{
\dontrun{
# save sound files
library(warbleR) 
data(list = c("Phae.long1", "Phae.long2", "Phae.long3", "Phae.long4"))
writeWave(Phae.long1, file.path(tempdir(), "Phae.long1.wav"), extensible = FALSE)
writeWave(Phae.long2, file.path(tempdir(), "Phae.long2.wav"), extensible = FALSE)

# here replace with the path where 'Raven' is install in your computer
raven.path <- "PATH_TO_RAVEN_DIRECTORY_HERE" 

# run function 
run_raven(raven.path = raven.path, sound.files = c("Phae.long1.wav", "Phae.long2.wav"),
 at.the.time = 2, import = T, name.from.file = T, ext.case = "upper", 
 all.data = TRUE, path = tempdir())  
 
#getting all the data
rav.dat<-run_raven(all.data = TRUE, raven.path = raven.path)
# View(rav.dat)

writeWave(Phae.long3, file.path(tempdir(), "Phae.long3.wav"), extensible = FALSE)
writeWave(Phae.long4, file.path(tempdir(), "Phae.long4.wav"), extensible = FALSE)

# run function on all the wav files in the working directory 3 at the time
run_raven(raven.path = raven.path, sound.files = list.files(pattern = "\\\\.wav$", 
ignore.case = TRUE, path = tempdir()), at.the.time = 3, import = FALSE, 
path = tempdir())
  
}

}
\seealso{
\code{\link{imp_raven}}; \code{\link{imp_syrinx}}
}
\author{
Marcelo Araya-Salas (\email{marceloa27@gmail.com})
}
