% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readdatamlx.R
\name{readDatamlx}
\alias{readDatamlx}
\title{Read formatted data file}
\usage{
readDatamlx(data = NULL, project = NULL, addl.ss = 10)
}
\arguments{
\item{data}{a list with fields
\itemize{
  \item \code{dataFile}: path of a formatted data file
  \item \code{headerTypes}: a vector of strings
}}

\item{project}{a Monolix project}

\item{addl.ss}{number of additional doses to use for steady-state  (default=10)}
}
\value{
A list of data frames
}
\description{
Read data in a Monolix/NONMEM format. 
Either the path to the data file or a Monolix project that uses this data file can be provided as input.
}
\details{
See http://rsmlx.webpopix.org/readdatamlx/ for more details.
}
\examples{
\dontrun{
# using a data file:
warfarinPK <- list(dataFile = "data/warfarinPK.csv",
                   headerTypes = c("id", "time", "observation", "amount", 
                                   "contcov", "contcov", "catcov"),
                   administration = "oral")
d <- readDatamlx(data=warfarinPK)
names(d)
head(d$treatment)
head(d$covariate)
head(d$y)

# using a Monolix project:
d <- readDatamlx(project='projects/warfarinPK.mlxtran')

}
}
